/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.DuplicateLayerException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.EastNorthBound;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class CadastreInterface {
    public boolean downloadCanceled;
    private HttpClient.Response urlConn;
    private String csrfToken;
    private String cookie;
    private String interfaceRef;
    private String lastWMSLayerName;
    private URL searchFormURL;
    private List<String> listOfCommunes = new ArrayList<String>();
    private List<String> listOfTA = new ArrayList<String>();
    private List<PlanImage> listOfFeuilles = new ArrayList<PlanImage>();
    private long cookieTimestamp;
    public static final String BASE_URL = "https://www.cadastre.gouv.fr";
    static final String C_IMAGE_FORMAT = "Cette commune est au format ";
    static final String C_COMMUNE_LIST_START = "<select name=\"codeCommune\"";
    static final String C_COMMUNE_LIST_END = "</select>";
    static final String C_OPTION_LIST_START = "<option value=\"";
    static final String C_OPTION_LIST_END = "</option>";
    static final String C_BBOX_COMMUN_START = "new GeoBox(";
    static final String C_BBOX_COMMUN_END = ")";
    static final String C_INTERFACE_VECTOR = "afficherCarteCommune.do";
    static final String C_INTERFACE_RASTER_TA = "afficherCarteTa.do";
    static final String C_INTERFACE_RASTER_FEUILLE = "afficherCarteFeuille.do?CSRF_TOKEN=";
    static final String C_IMAGE_LINK_START = "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteFeuille.do?CSRF_TOKEN=";
    static final String C_TA_IMAGE_LINK_START = "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteTa.do?CSRF_TOKEN=";
    static final String C_IMAGE_NAME_START = ">Feuille ";
    static final String C_TA_IMAGE_NAME_START = "Tableau d'assemblage <strong>";
    static final String C_CSRF_TOKEN = "CSRF_TOKEN=";
    static final String C_F = "&amp;f=";
    static final long COOKIE_EXPIRATION = 1800000L;
    static final int RETRIES_GET_COOKIE = 10;

    public boolean retrieveInterface(WMSLayer wmsLayer) throws DuplicateLayerException, WMSException {
        if (wmsLayer.getName().isEmpty()) {
            return false;
        }
        boolean isCookieExpired = this.isCookieExpired();
        if (wmsLayer.getName().equals(this.lastWMSLayerName) && !isCookieExpired) {
            return true;
        }
        if (!wmsLayer.getName().equals(this.lastWMSLayerName)) {
            this.interfaceRef = null;
        }
        this.downloadCanceled = false;
        try {
            if (this.cookie == null || isCookieExpired) {
                this.getCookie();
                this.interfaceRef = null;
            }
            if (this.cookie == null) {
                throw new WMSException(I18n.tr((String)"Cannot open a new client session.\nServer in maintenance or temporary overloaded.", (Object[])new Object[0]));
            }
            if (this.interfaceRef == null) {
                this.getInterface(wmsLayer);
                this.lastWMSLayerName = wmsLayer.getName();
            }
            this.openInterface();
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Town/city {0} not found or not available\nor action canceled", (Object[])new Object[]{wmsLayer.getLocation()})));
            return false;
        }
        return true;
    }

    private void getCookie() throws IOException {
        boolean success = false;
        int retries = 10;
        try {
            this.searchFormURL = new URL("https://www.cadastre.gouv.fr/scpc/accueil.do");
            while (!success && retries > 0) {
                this.urlConn = this.getHttpClient(this.searchFormURL).setHeader("Connection", "close").connect();
                if (this.urlConn.getResponseCode() == 200) {
                    this.urlConn.fetchContent();
                    success = true;
                    CookieHandler cookieHandler = CookieHandler.getDefault();
                    if (cookieHandler != null) {
                        if (!this.handleCookie(cookieHandler.get(this.searchFormURL.toURI(), new HashMap<String, List<String>>()).get("Cookie").get(0))) continue;
                        break;
                    }
                    for (Map.Entry e : this.urlConn.getHeaderFields().entrySet()) {
                        if ("Set-Cookie".equals(e.getKey()) && e.getValue() != null && !((List)e.getValue()).isEmpty() && this.handleCookie((String)((List)e.getValue()).get(0))) break;
                    }
                    continue;
                }
                Logging.warn((String)("Request to home page failed. Http error:" + this.urlConn.getResponseCode() + ". Try again " + retries + " times"));
                CadastrePlugin.safeSleep(3000L);
                --retries;
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IOException("Illegal url.", e);
        }
    }

    private boolean handleCookie(String pCookie) {
        this.cookie = pCookie;
        if (this.cookie == null || this.cookie.isEmpty()) {
            Logging.warn((String)"received empty cookie");
            this.cookie = null;
        } else {
            int index = this.cookie.indexOf(59);
            if (index > -1) {
                this.cookie = this.cookie.substring(0, index);
            }
            this.cookieTimestamp = new Date().getTime();
            Logging.info((String)("received cookie=" + this.cookie + " at " + new Date(this.cookieTimestamp)));
        }
        return this.cookie != null;
    }

    public void resetCookie() {
        this.lastWMSLayerName = null;
        this.cookie = null;
    }

    public boolean isCookieExpired() {
        long now = new Date().getTime();
        if (now - this.cookieTimestamp > 1800000L) {
            Logging.info((String)("cookie received at " + new Date(this.cookieTimestamp) + " expired (now is " + new Date(now) + C_BBOX_COMMUN_END));
            return true;
        }
        return false;
    }

    public void resetInterfaceRefIfNewLayer(String newWMSLayerName) {
        if (!newWMSLayerName.equals(this.lastWMSLayerName)) {
            this.interfaceRef = null;
            this.cookie = null;
        }
    }

    public HttpClient getHttpClient(URL url) {
        return HttpClient.create((URL)url).setHeader("Cookie", this.cookie);
    }

    public HttpClient getHttpClient(URL url, String method) {
        return HttpClient.create((URL)url, (String)method).setHeader("Cookie", this.cookie);
    }

    private void getInterface(WMSLayer wmsLayer) throws IOException, DuplicateLayerException {
        this.interfaceRef = this.postForm(wmsLayer, "");
        if (this.interfaceRef == null) {
            if (!wmsLayer.getCodeCommune().isEmpty()) {
                this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
            } else {
                int res;
                if (this.listOfCommunes.size() > 1) {
                    String selected = this.selectMunicipalityDialog();
                    if (selected != null) {
                        String newCodeCommune = selected.substring(1, selected.indexOf(62) - 2);
                        String newLocation = selected.substring(selected.indexOf(62) + 1, selected.lastIndexOf(" - "));
                        wmsLayer.setCodeCommune(newCodeCommune);
                        wmsLayer.setLocation(newLocation);
                        Main.pref.put("cadastrewms.codeCommune", newCodeCommune);
                        Main.pref.put("cadastrewms.location", newLocation);
                    }
                    CadastreInterface.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
                }
                if (this.listOfCommunes.size() == 1 && wmsLayer.isRaster() && (res = this.selectFeuilleDialog()) != -1) {
                    wmsLayer.setCodeCommune(this.listOfFeuilles.get((int)res).name);
                    CadastreInterface.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = CadastreInterface.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune(), this.csrfToken);
                }
            }
        }
        if (this.interfaceRef == null) {
            throw new IOException("Town/city " + wmsLayer.getLocation() + " not found.");
        }
    }

    private void openInterface() throws IOException {
        try {
            URL interfaceURL = new URL("https://www.cadastre.gouv.fr/scpc/" + this.interfaceRef);
            this.urlConn = this.getHttpClient(interfaceURL).connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot open Cadastre interface. GET response:" + this.urlConn.getResponseCode());
            }
            String lines = this.urlConn.fetchContent();
            if (Logging.isDebugEnabled()) {
                Logging.debug((String)lines.toString());
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("CadastreGrabber: Illegal url.").initCause(e);
        }
    }

    private String postForm(WMSLayer wmsLayer, String codeCommune) throws IOException {
        try {
            this.listOfCommunes.clear();
            this.listOfTA.clear();
            String content = "numerovoie=";
            content = content + "&indiceRepetition=";
            content = content + "&nomvoie=";
            content = content + "&lieuDit=";
            if (codeCommune.isEmpty()) {
                content = content + "&ville=" + URLEncoder.encode(wmsLayer.getLocation(), "UTF-8");
                content = content + "&codePostal=";
            } else {
                content = content + "&codeCommune=" + codeCommune;
            }
            content = content + "&codeDepartement=";
            content = content + wmsLayer.getDepartement();
            content = content + "&nbResultatParPage=10";
            content = content + "&x=0&y=0";
            this.searchFormURL = new URL("https://www.cadastre.gouv.fr/scpc/rechercherPlan.do");
            this.urlConn = this.getHttpClient(this.searchFormURL, "POST").setRequestBody(content.getBytes(StandardCharsets.UTF_8)).connect();
            String lines = this.urlConn.fetchContent();
            this.urlConn.disconnect();
            if (lines != null) {
                int i = lines.indexOf(C_IMAGE_FORMAT);
                if (i > -1) {
                    wmsLayer.setRaster("image".equals(lines.substring(i + C_IMAGE_FORMAT.length(), lines.indexOf(46, i))));
                }
                this.csrfToken = null;
                i = lines.indexOf(C_CSRF_TOKEN);
                if (i > -1) {
                    this.csrfToken = lines.substring(i + C_CSRF_TOKEN.length(), Math.min(lines.indexOf(34, i), lines.indexOf(38, i)));
                }
                i = lines.indexOf(C_INTERFACE_VECTOR);
                if (!wmsLayer.isRaster() && i != -1) {
                    lines = lines.substring(i, lines.length());
                    lines = lines.substring(0, lines.indexOf(39));
                    lines = Entities.unescape((String)lines);
                    Logging.info((String)("interface ref.:" + lines));
                    return lines;
                }
                if (wmsLayer.isRaster() && lines.indexOf(C_INTERFACE_RASTER_TA) != -1) {
                    lines = this.getFeuillesList(this.csrfToken);
                    if (!this.downloadCanceled) {
                        int res;
                        this.parseFeuillesList(lines, this.csrfToken);
                        if (!this.listOfFeuilles.isEmpty() && (res = this.selectFeuilleDialog()) != -1) {
                            wmsLayer.setCodeCommune(this.listOfFeuilles.get((int)res).name);
                            CadastreInterface.checkLayerDuplicates(wmsLayer);
                            this.interfaceRef = CadastreInterface.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune(), this.csrfToken);
                            wmsLayer.setCodeCommune(this.listOfFeuilles.get((int)res).ref);
                            lines = CadastreInterface.buildRasterFeuilleInterfaceRef(this.listOfFeuilles.get((int)res).ref, this.csrfToken);
                            lines = Entities.unescape((String)lines);
                            Logging.info((String)("interface ref.:" + lines));
                            return lines;
                        }
                    }
                    return null;
                }
                if (lines.indexOf(C_COMMUNE_LIST_START) != -1 && lines.indexOf(C_COMMUNE_LIST_END) != -1) {
                    i = lines.indexOf(C_COMMUNE_LIST_START);
                    this.parseCommuneList(lines.substring(i, lines.indexOf(C_COMMUNE_LIST_END, i)));
                }
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
        catch (DuplicateLayerException e) {
            Logging.error((Throwable)e);
        }
        return null;
    }

    private void parseCommuneList(String input) {
        if (input.indexOf(C_OPTION_LIST_START) != -1) {
            while (input.indexOf(C_OPTION_LIST_START) != -1) {
                int i = input.indexOf(C_OPTION_LIST_START);
                int j = input.indexOf(C_OPTION_LIST_END, i + C_OPTION_LIST_START.length());
                int k = input.indexOf(34, i + C_OPTION_LIST_START.length());
                if (j != -1 && k > i + C_OPTION_LIST_START.length()) {
                    String lov = input.substring(i + C_OPTION_LIST_START.length() - 1, j);
                    if (lov.indexOf(62) != -1) {
                        Logging.info((String)("parse " + lov));
                        this.listOfCommunes.add(lov);
                    } else {
                        Logging.error((String)("unable to parse commune string:" + lov));
                    }
                }
                input = input.substring(j + C_OPTION_LIST_END.length());
            }
        }
    }

    private String getFeuillesList(String csrfToken) {
        try {
            URL getAllImagesURL = new URL("https://www.cadastre.gouv.fr/scpc/listerFeuillesParcommune.do?CSRF_TOKEN=" + csrfToken + "&keepVolatileSession=&offset=2000");
            return this.getHttpClient(getAllImagesURL).connect().fetchContent();
        }
        catch (IOException e) {
            this.listOfFeuilles.clear();
            Logging.error((Throwable)e);
            return "";
        }
    }

    private void parseFeuillesList(String input, String csrfToken) {
        this.listOfFeuilles.clear();
        String inputTA = input;
        if (Main.pref.getBoolean("cadastrewms.useTA", false)) {
            while (inputTA.indexOf(C_TA_IMAGE_LINK_START) != -1) {
                inputTA = inputTA.substring(inputTA.indexOf(C_TA_IMAGE_LINK_START) + C_TA_IMAGE_LINK_START.length() + csrfToken.length() + C_F.length());
                String refTA = inputTA.substring(0, inputTA.indexOf(39));
                String nameTA = inputTA.substring(inputTA.indexOf(C_TA_IMAGE_NAME_START) + C_TA_IMAGE_NAME_START.length());
                nameTA = nameTA.substring(0, nameTA.indexOf(60));
                this.listOfFeuilles.add(new PlanImage(nameTA, refTA));
            }
        }
        while (input.indexOf(C_IMAGE_LINK_START) != -1) {
            input = input.substring(input.indexOf(C_IMAGE_LINK_START) + C_IMAGE_LINK_START.length() + csrfToken.length() + C_F.length());
            String refFeuille = input.substring(0, input.indexOf(39));
            String nameFeuille = input.substring(input.indexOf(C_IMAGE_NAME_START) + C_IMAGE_NAME_START.length(), input.indexOf(" -"));
            this.listOfFeuilles.add(new PlanImage(nameFeuille, refFeuille));
        }
    }

    private String selectMunicipalityDialog() {
        return (String)GuiHelper.runInEDTAndWaitAndReturn(() -> {
            JPanel p = new JPanel(new GridBagLayout());
            String[] communeList = new String[this.listOfCommunes.size() + 1];
            communeList[0] = I18n.tr((String)"Choose from...", (Object[])new Object[0]);
            for (int i = 0; i < this.listOfCommunes.size(); ++i) {
                communeList[i + 1] = this.listOfCommunes.get(i).substring(this.listOfCommunes.get(i).indexOf(62) + 1);
            }
            JComboBox<String> inputCommuneList = new JComboBox<String>(communeList);
            p.add(inputCommuneList, GBC.eol().fill(2).insets(10, 0, 0, 0));
            JOptionPane pane = new JOptionPane(p, 1, 2, null);
            JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select commune", (Object[])new Object[0]));
            CadastrePlugin.prepareDialog(dialog);
            dialog.setVisible(true);
            if (!Integer.valueOf(0).equals(pane.getValue())) {
                return null;
            }
            return this.listOfCommunes.get(inputCommuneList.getSelectedIndex() - 1);
        });
    }

    private int selectFeuilleDialog() {
        return (Integer)GuiHelper.runInEDTAndWaitAndReturn(() -> {
            JPanel p = new JPanel(new GridBagLayout());
            ArrayList<String> imageNames = new ArrayList<String>();
            for (PlanImage src : this.listOfFeuilles) {
                imageNames.add(src.name);
            }
            JComboBox<String> inputFeuilleList = new JComboBox<String>(imageNames.toArray(new String[0]));
            p.add(inputFeuilleList, GBC.eol().fill(2).insets(10, 0, 0, 0));
            JOptionPane pane = new JOptionPane(p, 1, 2, null);
            JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select Feuille", (Object[])new Object[0]));
            CadastrePlugin.prepareDialog(dialog);
            dialog.setVisible(true);
            if (!Integer.valueOf(0).equals(pane.getValue())) {
                return -1;
            }
            return inputFeuilleList.getSelectedIndex();
        });
    }

    private static String buildRasterFeuilleInterfaceRef(String codeCommune, String csrfToken) {
        return C_INTERFACE_RASTER_FEUILLE + csrfToken + "&f=" + codeCommune;
    }

    public void retrieveCommuneBBox(WMSLayer wmsLayer) throws IOException {
        if (this.interfaceRef == null) {
            return;
        }
        this.searchFormURL = new URL("https://www.cadastre.gouv.fr/scpc/" + this.interfaceRef + "&dontSaveLastForward&keepVolatileSession=");
        String line = this.getHttpClient(this.searchFormURL).connect().fetchContent();
        CadastreInterface.parseBBoxCommune(wmsLayer, line);
        if (wmsLayer.isRaster() && !wmsLayer.isAlreadyGeoreferenced()) {
            CadastreInterface.parseGeoreferences(wmsLayer, line);
        }
    }

    private static void parseBBoxCommune(WMSLayer wmsLayer, String input) {
        if (input.indexOf(C_BBOX_COMMUN_START) != -1) {
            input = input.substring(input.indexOf(C_BBOX_COMMUN_START));
            int i = input.indexOf(44);
            double minx = Double.parseDouble(input.substring(C_BBOX_COMMUN_START.length(), i));
            int j = input.indexOf(44, i + 1);
            double miny = Double.parseDouble(input.substring(i + 1, j));
            int k = input.indexOf(44, j + 1);
            double maxx = Double.parseDouble(input.substring(j + 1, k));
            int l = input.indexOf(C_BBOX_COMMUN_END, k + 1);
            double maxy = Double.parseDouble(input.substring(k + 1, l));
            wmsLayer.setCommuneBBox(new EastNorthBound(new EastNorth(minx, miny), new EastNorth(maxx, maxy)));
        }
    }

    private static void parseGeoreferences(WMSLayer wmsLayer, String input) {
    }

    private static void checkLayerDuplicates(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (MainApplication.getMap() != null) {
            for (Layer l : MainApplication.getLayerManager().getLayers()) {
                if (!(l instanceof WMSLayer) || !l.getName().equals(wmsLayer.getName()) || l.equals(wmsLayer)) continue;
                Logging.info((String)("Try to grab into a new layer when " + wmsLayer.getName() + " is already opened."));
                MainApplication.getLayerManager().removeLayer((Layer)wmsLayer);
                throw new DuplicateLayerException();
            }
        }
    }

    public void cancel() {
        if (this.urlConn != null) {
            this.urlConn.disconnect();
        }
        this.downloadCanceled = true;
        this.lastWMSLayerName = null;
    }

    public InputStream getContent(URL url) throws IOException, OsmTransferException {
        this.urlConn = this.getHttpClient(url).setHeader("Connection", "close").connect();
        return this.urlConn.getContent();
    }

    static class PlanImage {
        String name;
        String ref;

        PlanImage(String name, String ref) {
            this.name = name;
            this.ref = ref;
        }
    }
}

