/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTile;

public class ElevationGridTileController
extends TileController {
    public ElevationGridTileController(TileSource source, TileCache tileCache, TileLoaderListener listener, TileLoader loader) {
        super(source, tileCache, listener);
        this.tileSource = source;
        this.tileLoader = loader;
    }

    public Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new ElevationGridTile(this.tileSource, tilex, tiley, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (tile.hasError()) {
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.tileLoader.createTileLoaderJob(tile).submit();
        }
        return tile;
    }
}

