/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.reader;

import java.io.File;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMEntity;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMRelation;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMWay;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.XMLReader;

public class OSMXMLReader
extends XMLReader {
    private OSMGraph osmgraph = new OSMGraph();

    public OSMXMLReader(String filename) {
        super(filename);
    }

    public OSMXMLReader(File file) {
        super(file);
    }

    private void readAttributes(OSMEntity entity) {
        String temp = this.parser.getAttributeValue(null, "changeset");
        if (temp != null) {
            entity.setChangeset(Integer.parseInt(temp));
        }
        entity.setId(Long.parseLong(this.parser.getAttributeValue(null, "id")));
        entity.setTimestamp(this.parser.getAttributeValue(null, "timestamp"));
        temp = this.parser.getAttributeValue(null, "uid");
        if (temp != null) {
            entity.setUid(Integer.parseInt(temp));
        }
        if ((temp = this.parser.getAttributeValue(null, "uid")) != null) {
            entity.setUid(Integer.parseInt(temp));
        }
        entity.setUser(this.parser.getAttributeValue(null, "user"));
        temp = this.parser.getAttributeValue(null, "visible");
        if (temp != null) {
            if (temp.equals("true") || temp.equals("1")) {
                entity.setVisible(true);
            }
        } else {
            entity.setVisible(false);
        }
        if ((temp = this.parser.getAttributeValue(null, "version")) != null) {
            entity.setversion(Integer.parseInt(temp));
        }
    }

    private void readMember(OSMRelation relation) {
        if (this.parser.getAttributeValue(null, "type").equals("node")) {
            relation.addMember(this.osmgraph.getNode(Integer.parseInt(this.parser.getAttributeValue(null, "ref"))), this.parser.getAttributeValue(null, "role"));
        } else if (this.parser.getAttributeValue(null, "type").equals("way")) {
            relation.addMember(this.osmgraph.getWay(Long.parseLong(this.parser.getAttributeValue(null, "ref"))), this.parser.getAttributeValue(null, "role"));
        } else if (this.parser.getAttributeValue(null, "type").equals("relation")) {
            relation.addMember(this.osmgraph.getRelation(Integer.parseInt(this.parser.getAttributeValue(null, "ref"))), this.parser.getAttributeValue(null, "role"));
        }
    }

    @Override
    public void parseXML() {
        OSMNode node = new OSMNode();
        OSMWay way = new OSMWay();
        OSMRelation relation = new OSMRelation();
        HashMap<String, String> hashmap = new HashMap<String, String>();
        try {
            while (this.parser.hasNext()) {
                switch (this.parser.getEventType()) {
                    case 1: {
                        String xmlelement = this.parser.getLocalName();
                        if (xmlelement.equals("node")) {
                            node = new OSMNode();
                            hashmap = new HashMap();
                            this.readAttributes(node);
                            node.setLatitude(Double.parseDouble(this.parser.getAttributeValue(null, "lat")));
                            node.setLongitude(Double.parseDouble(this.parser.getAttributeValue(null, "lon")));
                        }
                        if (xmlelement.equals("way")) {
                            way = new OSMWay();
                            hashmap = new HashMap();
                            this.readAttributes(way);
                        }
                        if (xmlelement.equals("relation")) {
                            relation = new OSMRelation();
                            hashmap = new HashMap();
                            this.readAttributes(relation);
                        }
                        if (xmlelement.equals("member")) {
                            this.readMember(relation);
                        }
                        if (xmlelement.equals("bounds")) {
                            this.osmgraph.setBbbottom(Double.parseDouble(this.parser.getAttributeValue(null, "minlat")));
                            this.osmgraph.setBbtop(Double.parseDouble(this.parser.getAttributeValue(null, "maxlat")));
                            this.osmgraph.setBbleft(Double.parseDouble(this.parser.getAttributeValue(null, "minlon")));
                            this.osmgraph.setBbright(Double.parseDouble(this.parser.getAttributeValue(null, "maxlon")));
                        }
                        if (xmlelement.equals("nd")) {
                            way.addNode(this.osmgraph.getNode(Integer.parseInt(this.parser.getAttributeValue(0))));
                        }
                        if (xmlelement.equals("tag")) {
                            hashmap.put(this.parser.getAttributeValue(null, "k"), this.parser.getAttributeValue(null, "v"));
                        }
                        if (!xmlelement.equals("relation")) break;
                        relation = new OSMRelation();
                        hashmap = new HashMap();
                        this.readAttributes(relation);
                        break;
                    }
                    case 2: {
                        if (this.parser.getLocalName().equals("node")) {
                            node.setHashmap(hashmap);
                            this.osmgraph.addNode(node);
                        }
                        if (this.parser.getLocalName().equals("way")) {
                            way.setHashmap(hashmap);
                            this.osmgraph.addWay(way);
                        }
                        if (!this.parser.getLocalName().equals("relation")) break;
                        relation.setHashmap(hashmap);
                        this.osmgraph.addRelation(relation);
                    }
                }
                this.parser.next();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void setOSMGraph(OSMGraph osmgraph) {
        this.osmgraph = osmgraph;
    }

    public OSMGraph getOSMGraph() {
        return this.osmgraph;
    }
}

