/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysCmdKeepLength;
import com.tilusnet.josm.plugins.alignways.geometry.AlignWaysGeomLine;
import com.tilusnet.josm.plugins.alignways.geometry.AlignWaysGeomPoint;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;

public class AlignWaysCmdKeepAngles
extends AlignWaysCmdKeepLength {
    private AlignWaysCmdKeepLength.AlignableStatus alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID;

    public AlignWaysCmdKeepAngles(DataSet ds) {
        super(ds);
        Map calcNodesKeepLength = this.calculatedNodes;
        Node[] nodeArr = this.algnSeg.getSegmentEndPoints().toArray(new Node[2]);
        EastNorth enCalc1 = (EastNorth)calcNodesKeepLength.get(nodeArr[0]);
        EastNorth enCalc2 = (EastNorth)calcNodesKeepLength.get(nodeArr[1]);
        AlignWaysGeomLine lineKeepLength = new AlignWaysGeomLine(enCalc1.getX(), enCalc1.getY(), enCalc2.getX(), enCalc2.getY());
        this.recalculateNodesAndValidate(lineKeepLength, nodeArr[0]);
        this.recalculateNodesAndValidate(lineKeepLength, nodeArr[1]);
    }

    private void recalculateNodesAndValidate(AlignWaysGeomLine alignedLineKeepLength, Node endpoint) {
        if (endpoint.getEastNorth().equals((Object)this.pivot)) {
            return;
        }
        ArrayList<WaySegment> alws = this.algnSeg.getAdjacentWaySegments(endpoint);
        int alwsSize = alws.size();
        if (0 < alwsSize && alwsSize <= 2) {
            int middlePtIdx;
            Node adjOther1 = this.getNonEqualNode(alws.get(0), endpoint);
            EastNorth enAdjOther1 = adjOther1.getEastNorth();
            Node adjOther2 = null;
            EastNorth enAdjOther2 = null;
            if (alwsSize == 2) {
                adjOther2 = this.getNonEqualNode(alws.get(1), endpoint);
                enAdjOther2 = adjOther2.getEastNorth();
                ArrayList<EastNorth> enAdjPts = new ArrayList<EastNorth>(3);
                enAdjPts.add(enAdjOther1);
                enAdjPts.add(endpoint.getEastNorth());
                enAdjPts.add(enAdjOther2);
                if (!this.isEnSetCollinear(enAdjPts)) {
                    this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_ANGLE_PRESERVING_CONFLICT;
                    return;
                }
            }
            AlignWaysGeomPoint isectPnt = alignedLineKeepLength.getIntersection(new AlignWaysGeomLine(enAdjOther1.getX(), enAdjOther1.getY(), endpoint.getEastNorth().getX(), endpoint.getEastNorth().getY()));
            EastNorth enIsectPt = null;
            if (isectPnt != null) {
                enIsectPt = new EastNorth(isectPnt.getX(), isectPnt.getY());
            } else if (alignedLineKeepLength.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_PARALLEL) {
                this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_ANGLE_PRESERVING_CONFLICT;
                return;
            }
            if (alwsSize == 2 && enIsectPt != null && (middlePtIdx = AlignWaysGeomPoint.getMiddleOf3(new AlignWaysGeomPoint(enIsectPt), new AlignWaysGeomPoint(enAdjOther1), new AlignWaysGeomPoint(enAdjOther2))) != 0) {
                double eps;
                EastNorth middlePt = null;
                switch (middlePtIdx) {
                    case 1: {
                        middlePt = enIsectPt;
                        break;
                    }
                    case 2: {
                        middlePt = enAdjOther1;
                        break;
                    }
                    case 3: {
                        middlePt = enAdjOther2;
                    }
                }
                if (middlePt != null && !middlePt.equalsEpsilon(enIsectPt, eps = 1.0E-6)) {
                    this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_XPOINT_FALLSOUT;
                    return;
                }
            }
            if (isectPnt != null) {
                this.calculatedNodes.put(endpoint, enIsectPt);
            }
        } else {
            this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_TOOMANY_CONNECTED_WS;
        }
    }

    private boolean isEnSetCollinear(ArrayList<EastNorth> enAdjPts) {
        ArrayList<AlignWaysGeomPoint> awAdjPts = new ArrayList<AlignWaysGeomPoint>();
        for (EastNorth en : enAdjPts) {
            AlignWaysGeomPoint pt = new AlignWaysGeomPoint(en.getX(), en.getY());
            awAdjPts.add(pt);
        }
        return AlignWaysGeomPoint.isSetCollinear(awAdjPts);
    }

    private Node getNonEqualNode(WaySegment waySegment, Node endpoint) {
        if (waySegment.getFirstNode().equals((Object)endpoint)) {
            return waySegment.getSecondNode();
        }
        if (waySegment.getSecondNode().equals((Object)endpoint)) {
            return waySegment.getFirstNode();
        }
        return null;
    }

    @Override
    void reportInvalidCommand(AlignWaysCmdKeepLength.AlignableStatus stat) {
        String statMsg;
        switch (stat) {
            case ALGN_INV_CONNECTED_UNSHARED_PIVOT: {
                statMsg = I18n.tr((String)"Please select two segments that don''t share any nodes.\nAlternatively put the pivot on their common node.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_OUTSIDE_WORLD: {
                statMsg = I18n.tr((String)"Aligning would result nodes ''outside the world''.\nAlignment not possible.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_TOOMANY_CONNECTED_WS: {
                statMsg = I18n.tr((String)"There is at least a non-pivot endpoint of the alignee that joins more than two way segments.\nPreserved angles type alignment is not possible.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_ANGLE_PRESERVING_CONFLICT: {
                statMsg = I18n.tr((String)"The alignment is not possible with maintaining the angles of the joint segments.\nEither choose the ''keep length'' aligning method or select other segments.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_XPOINT_FALLSOUT: {
                statMsg = I18n.tr((String)"An intersection point would fall outside its adjacent nodes.\nThis is an unsupported scenario.\n", (Object[])new Object[0]);
                break;
            }
            default: {
                statMsg = I18n.tr((String)"Undocumented problem occured.\n", (Object[])new Object[0]);
            }
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)statMsg, (Object[])new Object[0]), I18n.tr((String)"AlignWayS: Alignment not possible", (Object[])new Object[0]), 2);
    }

    @Override
    AlignWaysCmdKeepLength.AlignableStatus areSegsAlignable() {
        AlignWaysCmdKeepLength.AlignableStatus status = super.areSegsAlignable();
        if (this.alignableStatKeepAngles != AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID) {
            return this.alignableStatKeepAngles;
        }
        if (status != AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID) {
            return status;
        }
        return AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID;
    }
}

