/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.WindowClose;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCancel;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCloseBug;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteInvalidateBug;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteReOpenBug;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeBugStatusDialog
extends AbstractDialog {
    private static final long serialVersionUID = -4106150600118847229L;
    private JLabel lblNickname;
    private JTextField txtNickname;
    private JLabel lblComment;
    private JScrollPane cmpDescription;
    private JTextArea txtDescription;
    private JButton btnCancel;
    private JButton btnOk;
    private final String type;

    public ChangeBugStatusDialog(String title, String iconName, String type, JToggleButton firedButton, MapdustPlugin mapdustPlugin) {
        this.type = type;
        if (firedButton != null) {
            this.setFiredButton(firedButton);
        }
        this.setTitle(title);
        this.setModal(true);
        Image image = ImageProvider.get((String)iconName).getImage();
        this.setIconImage(image);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setFont(new Font("Times New Roman", 1, 14));
        this.setBackground(Color.white);
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(null);
        this.addComponents(mapdustPlugin);
        MapdustButtonPanel btnPanel = mapdustPlugin.getMapdustGUI().getPanel().getBtnPanel();
        this.addWindowListener(new WindowClose(this, btnPanel));
    }

    @Override
    public void addComponents(MapdustPlugin mapdustPlugin) {
        Rectangle bounds;
        MapdustExecuteAction okAction;
        Rectangle bounds2;
        Color backgroundColor = this.getContentPane().getBackground();
        Font font = new Font("Times New Roman", 1, 14);
        if (this.lblNickname == null) {
            bounds2 = new Rectangle(10, 10, 85, 25);
            this.lblNickname = ComponentUtil.createJLabel("Nickname", font, bounds2, null);
        }
        if (this.txtNickname == null) {
            bounds2 = new Rectangle(100, 10, 250, 25);
            this.txtNickname = ComponentUtil.createJTextField(bounds2);
            String nickname = Main.pref.get("mapdust.nickname");
            if (nickname.isEmpty()) {
                nickname = Main.pref.get("mapdust.josmUserName");
            }
            if (nickname != null && !nickname.isEmpty()) {
                this.txtNickname.setText(nickname);
            }
        }
        if (this.lblComment == null) {
            bounds2 = new Rectangle(10, 50, 89, 25);
            this.lblComment = ComponentUtil.createJLabel("Comment", font, bounds2, null);
        }
        if (this.cmpDescription == null) {
            bounds2 = new Rectangle(100, 50, 250, 80);
            this.txtDescription = new JTextArea();
            this.txtDescription.setLineWrap(true);
            this.txtDescription.setFont(new Font("Times New Roman", 0, 12));
            this.cmpDescription = ComponentUtil.createJScrollPane(this.txtDescription, bounds2, backgroundColor, false, true);
        }
        ExecuteCancel cancelAction = new ExecuteCancel(this, mapdustPlugin.getMapdustGUI());
        if (this.type.equals("close")) {
            okAction = new ExecuteCloseBug(this, mapdustPlugin.getMapdustGUI());
            okAction.addObserver(mapdustPlugin);
            okAction.addObserver(mapdustPlugin.getMapdustGUI());
        } else if (this.type.equals("invalidate")) {
            okAction = new ExecuteInvalidateBug(this, mapdustPlugin.getMapdustGUI());
            ((ExecuteInvalidateBug)okAction).addObserver(mapdustPlugin);
            ((ExecuteInvalidateBug)okAction).addObserver(mapdustPlugin.getMapdustGUI());
        } else {
            okAction = new ExecuteReOpenBug(this, mapdustPlugin.getMapdustGUI());
            ((ExecuteReOpenBug)okAction).addObserver(mapdustPlugin);
            ((ExecuteReOpenBug)okAction).addObserver(mapdustPlugin.getMapdustGUI());
        }
        if (this.btnCancel == null) {
            bounds = new Rectangle(260, 140, 90, 25);
            this.btnCancel = ComponentUtil.createJButton("Cancel", bounds, cancelAction);
        }
        if (this.btnOk == null) {
            bounds = new Rectangle(190, 140, 60, 25);
            this.btnOk = ComponentUtil.createJButton("OK", bounds, okAction);
        }
        this.add(this.lblNickname);
        this.add(this.txtNickname);
        this.add(this.lblComment);
        this.add(this.cmpDescription);
        this.add(this.btnCancel);
        this.add(this.btnOk);
        this.setSize(360, 170);
    }

    public JLabel getLblNickname() {
        return this.lblNickname;
    }

    public JTextField getTxtNickname() {
        return this.txtNickname;
    }

    public JLabel getLblComment() {
        return this.lblComment;
    }

    public JScrollPane getCmpDescription() {
        return this.cmpDescription;
    }

    public JTextArea getTxtDescription() {
        return this.txtDescription;
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JButton getBtnOk() {
        return this.btnOk;
    }
}

