/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerException;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerPlugin;
import org.openstreetmap.josm.tools.I18n;

public class LakewalkerWMS {
    private BufferedImage image;
    private int imagex;
    private int imagey;
    private List<BufferedImage> images = new Vector<BufferedImage>();
    private Map<String, Integer> imageindex = new HashMap<String, Integer>();
    private int resolution;
    private int tilesize;
    private String wmslayer;

    public LakewalkerWMS(int resolution, int tilesize, String wmslayer) {
        this.resolution = resolution;
        this.tilesize = tilesize;
        this.wmslayer = wmslayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getTile(int x, int y, ProgressMonitor progressMonitor) throws LakewalkerException {
        progressMonitor.beginTask(I18n.tr((String)"Downloading image tile...", (Object[])new Object[0]));
        try {
            String layer = "global_mosaic_base";
            int[] bottom_left_xy = new int[]{this.floor(x, this.tilesize), this.floor(y, this.tilesize)};
            int[] top_right_xy = new int[]{bottom_left_xy[0] + this.tilesize, bottom_left_xy[1] + this.tilesize};
            double[] topright_geo = this.xy_to_geo(top_right_xy[0], top_right_xy[1], this.resolution);
            double[] bottomleft_geo = this.xy_to_geo(bottom_left_xy[0], bottom_left_xy[1], this.resolution);
            String filename = this.wmslayer + "/landsat_" + this.resolution + "_" + this.tilesize + "_xy_" + bottom_left_xy[0] + "_" + bottom_left_xy[1] + ".png";
            NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
            DecimalFormat df = (DecimalFormat)nf;
            df.applyLocalizedPattern("0.000000");
            String urlloc = "http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=" + layer + "&styles=" + this.wmslayer + "&srs=EPSG:4326&format=image/png&bbox=" + df.format(bottomleft_geo[1]) + "," + df.format(bottomleft_geo[0]) + "," + df.format(topright_geo[1]) + "," + df.format(topright_geo[0]) + "&width=" + this.tilesize + "&height=" + this.tilesize;
            File file = new File(LakewalkerPlugin.getLakewalkerCacheDir(), filename);
            String hashkey = Integer.toString(bottom_left_xy[0]) + ":" + Integer.toString(bottom_left_xy[1]);
            if (this.image != null) {
                if (this.imagex != bottom_left_xy[0] || this.imagey != bottom_left_xy[1]) {
                    if (this.imageindex.containsKey(hashkey)) {
                        this.imagex = bottom_left_xy[0];
                        this.imagey = bottom_left_xy[1];
                        BufferedImage bufferedImage = this.image = this.images.get(this.imageindex.get(hashkey));
                        return bufferedImage;
                    }
                    this.image = null;
                } else {
                    BufferedImage bufferedImage = this.image;
                    return bufferedImage;
                }
            }
            try {
                System.out.println("Looking for image in disk cache: " + filename);
                this.image = ImageIO.read(file);
                this.images.add(this.image);
                this.imageindex.put(hashkey, this.images.size() - 1);
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find cached image, downloading.");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (this.image == null) {
                try {
                    System.out.println("Downloading from " + urlloc);
                    URL url = new URL(urlloc);
                    this.image = ImageIO.read(url);
                }
                catch (MalformedURLException e) {
                    System.out.println(e.getMessage());
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                if (this.image != null) {
                    this.images.add(this.image);
                    this.imageindex.put(hashkey, this.images.size() - 1);
                    this.saveimage(file, this.image);
                }
            }
            this.imagex = bottom_left_xy[0];
            this.imagey = bottom_left_xy[1];
            if (this.image == null) {
                throw new LakewalkerException(I18n.tr((String)"Could not acquire image", (Object[])new Object[0]));
            }
            BufferedImage bufferedImage = this.image;
            return bufferedImage;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void saveimage(File file, BufferedImage image) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
            System.out.println("Saved image to cache");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public int getPixel(int x, int y, ProgressMonitor progressMonitor) throws LakewalkerException {
        BufferedImage image = null;
        try {
            image = this.getTile(x, y, progressMonitor);
        }
        catch (LakewalkerException e) {
            System.out.println(e.getMessage());
            throw e;
        }
        int tx = this.floor(x, this.tilesize);
        int ty = this.floor(y, this.tilesize);
        int pixel_x = x - tx;
        int pixel_y = this.tilesize - 1 - (y - ty);
        int rgb = image.getRGB(pixel_x, pixel_y);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        int pixel = (int)(0.3 * (double)r + 0.59 * (double)b + 0.11 * (double)g);
        return pixel;
    }

    public int floor(int num, int precision) {
        double dnum = (double)num / (double)precision;
        BigDecimal val = new BigDecimal(dnum);
        val = val.setScale(0, 3);
        return val.intValue() * precision;
    }

    public double floor(double num) {
        BigDecimal val = new BigDecimal(num);
        val = val.setScale(0, 3);
        return val.doubleValue();
    }

    public double[] xy_to_geo(int x, int y, double resolution) {
        double[] geo = new double[]{(double)y / resolution, (double)x / resolution};
        return geo;
    }

    public int[] geo_to_xy(double lat, double lon, double resolution) {
        int[] xy = new int[]{(int)Math.floor(lon * resolution + 0.5), (int)Math.floor(lat * resolution + 0.5)};
        return xy;
    }
}

