/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.io.PrintStream;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.util.CRSCache;
import org.osgeo.proj4j.util.ProjectionUtil;

public class MetaCRSTestCase {
    private static final CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    String testName;
    String testMethod;
    String srcCrsAuth;
    String srcCrs;
    String tgtCrsAuth;
    String tgtCrs;
    double srcOrd1;
    double srcOrd2;
    double srcOrd3;
    double tgtOrd1;
    double tgtOrd2;
    double tgtOrd3;
    double tolOrd1;
    double tolOrd2;
    double tolOrd3;
    String using;
    String dataSource;
    String dataCmnts;
    String maintenanceCmnts;
    CoordinateReferenceSystem srcCS;
    CoordinateReferenceSystem tgtCS;
    ProjCoordinate srcPt = new ProjCoordinate();
    ProjCoordinate resultPt = new ProjCoordinate();
    private boolean isInTol;
    private CRSCache crsCache = null;

    public MetaCRSTestCase(String testName, String testMethod, String srcCrsAuth, String srcCrs, String tgtCrsAuth, String tgtCrs, double srcOrd1, double srcOrd2, double srcOrd3, double tgtOrd1, double tgtOrd2, double tgtOrd3, double tolOrd1, double tolOrd2, double tolOrd3, String using, String dataSource, String dataCmnts, String maintenanceCmnts) {
        this.testName = testName;
        this.testMethod = testMethod;
        this.srcCrsAuth = srcCrsAuth;
        this.srcCrs = srcCrs;
        this.tgtCrsAuth = tgtCrsAuth;
        this.tgtCrs = tgtCrs;
        this.srcOrd1 = srcOrd1;
        this.srcOrd2 = srcOrd2;
        this.srcOrd3 = srcOrd3;
        this.tgtOrd1 = tgtOrd1;
        this.tgtOrd2 = tgtOrd2;
        this.tgtOrd3 = tgtOrd3;
        this.tolOrd1 = tolOrd1;
        this.tolOrd2 = tolOrd2;
        this.tolOrd3 = tolOrd3;
        this.using = using;
        this.dataSource = dataSource;
        this.dataCmnts = dataCmnts;
        this.maintenanceCmnts = maintenanceCmnts;
    }

    public String getName() {
        return this.testName;
    }

    public String getSourceCrsName() {
        return MetaCRSTestCase.csName(this.srcCrsAuth, this.srcCrs);
    }

    public String getTargetCrsName() {
        return MetaCRSTestCase.csName(this.tgtCrsAuth, this.tgtCrs);
    }

    public CoordinateReferenceSystem getSourceCS() {
        return this.srcCS;
    }

    public CoordinateReferenceSystem getTargetCS() {
        return this.tgtCS;
    }

    public ProjCoordinate getSourceCoordinate() {
        return new ProjCoordinate(this.srcOrd1, this.srcOrd2, this.srcOrd3);
    }

    public ProjCoordinate getTargetCoordinate() {
        return new ProjCoordinate(this.tgtOrd1, this.tgtOrd2, this.tgtOrd3);
    }

    public ProjCoordinate getResultCoordinate() {
        return new ProjCoordinate(this.resultPt.x, this.resultPt.y);
    }

    public void setCache(CRSCache crsCache) {
        this.crsCache = crsCache;
    }

    public boolean execute(CRSFactory csFactory) {
        boolean isOK = false;
        this.srcCS = this.createCS(csFactory, this.srcCrsAuth, this.srcCrs);
        this.tgtCS = this.createCS(csFactory, this.tgtCrsAuth, this.tgtCrs);
        isOK = this.executeTransform(this.srcCS, this.tgtCS);
        return isOK;
    }

    public static String csName(String auth, String code) {
        return auth + ":" + code;
    }

    public CoordinateReferenceSystem createCS(CRSFactory csFactory, String auth, String code) {
        String name = MetaCRSTestCase.csName(auth, code);
        if (this.crsCache != null) {
            return this.crsCache.createFromName(name);
        }
        CoordinateReferenceSystem cs = csFactory.createFromName(name);
        return cs;
    }

    private boolean executeTransform(CoordinateReferenceSystem srcCS, CoordinateReferenceSystem tgtCS) {
        this.srcPt.x = this.srcOrd1;
        this.srcPt.y = this.srcOrd2;
        CoordinateTransform trans = ctFactory.createTransform(srcCS, tgtCS);
        trans.transform(this.srcPt, this.resultPt);
        double dx = Math.abs(this.resultPt.x - this.tgtOrd1);
        double dy = Math.abs(this.resultPt.y - this.tgtOrd2);
        this.isInTol = dx <= this.tolOrd1 && dy <= this.tolOrd2;
        return this.isInTol;
    }

    public void print(PrintStream os) {
        System.out.println(this.testName);
        System.out.println(ProjectionUtil.toString(this.srcPt) + " -> " + ProjectionUtil.toString(this.resultPt) + " ( expected: " + this.tgtOrd1 + ", " + this.tgtOrd2 + " )");
        if (!this.isInTol) {
            System.out.println("FAIL");
            System.out.println("Src CRS: (" + this.srcCrsAuth + ":" + this.srcCrs + ") " + this.srcCS.getParameterString());
            System.out.println("Tgt CRS: (" + this.tgtCrsAuth + ":" + this.tgtCrs + ") " + this.tgtCS.getParameterString());
        }
    }
}

