/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;

public abstract class EngineWrapper
implements Engine {
    private Engine engine;

    protected EngineWrapper(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        return this.getWrappedEngine().put(value, serializer);
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        return this.getWrappedEngine().get(recid, serializer);
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.getWrappedEngine().update(recid, value, serializer);
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        return this.getWrappedEngine().compareAndSwap(recid, expectedOldValue, newValue, serializer);
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.getWrappedEngine().delete(recid, serializer);
    }

    @Override
    public void close() {
        Engine e = this.engine;
        if (e != null) {
            e.close();
        }
        this.engine = null;
    }

    @Override
    public boolean isClosed() {
        return this.engine == null;
    }

    @Override
    public void commit() {
        this.getWrappedEngine().commit();
    }

    @Override
    public void rollback() {
        this.getWrappedEngine().rollback();
    }

    @Override
    public boolean isReadOnly() {
        return this.getWrappedEngine().isReadOnly();
    }

    @Override
    public void compact() {
        this.getWrappedEngine().compact();
    }

    public Engine getWrappedEngine() {
        return EngineWrapper.checkClosed(this.engine);
    }

    protected static <V> V checkClosed(V v) {
        if (v == null) {
            throw new IllegalAccessError("DB has been closed");
        }
        return v;
    }

    public static class SynchronizedEngineWrapper
    extends EngineWrapper {
        protected SynchronizedEngineWrapper(Engine engine) {
            super(engine);
        }

        @Override
        public synchronized <A> long put(A value, Serializer<A> serializer) {
            return super.put(value, serializer);
        }

        @Override
        public synchronized <A> A get(long recid, Serializer<A> serializer) {
            return super.get(recid, serializer);
        }

        @Override
        public synchronized <A> void update(long recid, A value, Serializer<A> serializer) {
            super.update(recid, value, serializer);
        }

        @Override
        public synchronized <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
        }

        @Override
        public synchronized <A> void delete(long recid, Serializer<A> serializer) {
            super.delete(recid, serializer);
        }

        @Override
        public synchronized void close() {
            super.close();
        }

        @Override
        public synchronized boolean isClosed() {
            return super.isClosed();
        }

        @Override
        public synchronized void commit() {
            super.commit();
        }

        @Override
        public synchronized void rollback() {
            super.rollback();
        }

        @Override
        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        @Override
        public synchronized void compact() {
            super.compact();
        }
    }

    public static class ImmutabilityCheckEngine
    extends EngineWrapper {
        protected LongConcurrentHashMap<Item<?>> items = new LongConcurrentHashMap();

        protected ImmutabilityCheckEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            A ret;
            Item<?> item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            if ((ret = super.get(recid, serializer)) != null) {
                this.items.put(recid, new Item<A>(serializer, ret));
            }
            return ret;
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long ret = super.put(value, serializer);
            if (value != null) {
                this.items.put(ret, new Item<A>(serializer, value));
            }
            return ret;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            Item<?> item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            super.update(recid, value, serializer);
            if (value != null) {
                this.items.put(recid, new Item<A>(serializer, value));
            }
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            boolean ret;
            Item<?> item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            if ((ret = super.compareAndSwap(recid, expectedOldValue, newValue, serializer)) && newValue != null) {
                this.items.put(recid, new Item(serializer, item));
            }
            return ret;
        }

        @Override
        public void close() {
            super.close();
            Iterator<Item<?>> iter = this.items.valuesIterator();
            while (iter.hasNext()) {
                iter.next().check();
            }
            this.items.clear();
        }

        protected static class Item<E> {
            final Serializer<E> serializer;
            final E item;
            final int oldChecksum;

            public Item(Serializer<E> serializer, E item) {
                if (item == null || serializer == null) {
                    throw new AssertionError((Object)"null");
                }
                this.serializer = serializer;
                this.item = item;
                this.oldChecksum = this.checksum();
                if (this.oldChecksum != this.checksum()) {
                    throw new AssertionError((Object)"inconsistent serialization");
                }
            }

            private int checksum() {
                try {
                    DataOutput2 out = new DataOutput2();
                    this.serializer.serialize(out, this.item);
                    byte[] bb = out.copyBytes();
                    return Arrays.hashCode(bb);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }

            void check() {
                int newChecksum = this.checksum();
                if (this.oldChecksum != newChecksum) {
                    throw new AssertionError((Object)("Record instance was modified: \n  " + this.item + "\n  " + this.serializer));
                }
            }
        }
    }

    public static class DebugEngine
    extends EngineWrapper {
        final Queue<Record> records = new ConcurrentLinkedQueue<Record>();

        public DebugEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = super.put(value, serializer);
            this.records.add(new Record(recid, "INSERT \n  val:" + value + "\n  ser:" + serializer));
            return recid;
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            A ret = super.get(recid, serializer);
            this.records.add(new Record(recid, "GET \n  val:" + ret + "\n  ser:" + serializer));
            return ret;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            super.update(recid, value, serializer);
            this.records.add(new Record(recid, "UPDATE \n  val:" + value + "\n  ser:" + serializer));
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            super.delete(recid, serializer);
            this.records.add(new Record(recid, "DEL"));
        }

        protected static final class Record {
            final long recid;
            final String desc;

            public Record(long recid, String desc) {
                this.recid = recid;
                this.desc = desc;
            }
        }
    }

    public static class ByteTransformEngine
    extends EngineWrapper {
        protected Serializer<byte[]> blockSerializer;

        public ByteTransformEngine(Engine engine, Serializer<byte[]> blockSerializer) {
            super(engine);
            this.blockSerializer = blockSerializer;
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            try {
                Engine e = this.getWrappedEngine();
                Serializer<byte[]> ser = ByteTransformEngine.checkClosed(this.blockSerializer);
                if (value == null) {
                    return e.put(null, ser);
                }
                DataOutput2 out = new DataOutput2();
                serializer.serialize(out, value);
                byte[] b = out.copyBytes();
                return e.put(b, ser);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            try {
                byte[] b = this.getWrappedEngine().get(recid, ByteTransformEngine.checkClosed(this.blockSerializer));
                if (b == null) {
                    return null;
                }
                DataInput2 in = new DataInput2(ByteBuffer.wrap(b), 0);
                return serializer.deserialize(in, b.length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            try {
                DataOutput2 out = new DataOutput2();
                serializer.serialize(out, value);
                byte[] b = out.copyBytes();
                this.getWrappedEngine().update(recid, b, ByteTransformEngine.checkClosed(this.blockSerializer));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            super.close();
            this.blockSerializer = null;
        }
    }

    public static class ReadOnlyEngine
    extends EngineWrapper {
        public ReadOnlyEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void commit() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

