/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mapdb.SerializerBase;

public final class DataInput2
implements DataInput {
    ByteBuffer buf;
    int pos;

    public DataInput2(ByteBuffer buf, int pos) {
        this.buf = buf;
        this.pos = pos;
    }

    public DataInput2(byte[] b) {
        this(ByteBuffer.wrap(b), 0);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            b[i] = this.readByte();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf.get(this.pos++) == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf.get(this.pos++);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buf.get(this.pos++) & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        short ret = this.buf.getShort(this.pos);
        this.pos += 2;
        return ret;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (this.buf.get(this.pos++) & 0xFF) << 8 | this.buf.get(this.pos++) & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        int ret = this.buf.getInt(this.pos);
        this.pos += 4;
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = this.buf.getLong(this.pos);
        this.pos += 8;
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        float ret = this.buf.getFloat(this.pos);
        this.pos += 4;
        return ret;
    }

    @Override
    public double readDouble() throws IOException {
        double ret = this.buf.getDouble(this.pos);
        this.pos += 8;
        return ret;
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF() throws IOException {
        return SerializerBase.deserializeString(this);
    }
}

