/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;
import org.openstreetmap.josm.tools.I18n;

public class EdigeoFileGEO
extends EdigeoLotFile<GeoBlock> {
    public EdigeoFileGEO(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("GEO", CoorReference.class);
        this.register("RPR", Offset.class);
        lot.geo = this;
    }

    public CoorReference getCoorReference() {
        return this.blocks.getInstances(CoorReference.class).get(0);
    }

    public Offset getOffset() {
        return this.blocks.getInstances(Offset.class).get(0);
    }

    public static class Offset
    extends GeoBlock {
        int nOffsetPoints;
        final List<String> offsetPointIds = new ArrayList<String>();
        final List<EastNorth> offsetInputCoor = new ArrayList<EastNorth>();
        final List<EastNorth> offsetReferCoor = new ArrayList<EastNorth>();
        int nControlPoints;
        final List<String> controlPointIds = new ArrayList<String>();
        final List<EastNorth> controlInputCoor = new ArrayList<EastNorth>();
        final List<EastNorth> controlReferCoor = new ArrayList<EastNorth>();

        Offset(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "RPC": {
                    this.nOffsetPoints = this.safeGetInt(r);
                    break;
                }
                case "RPI": {
                    this.safeGet(r, this.offsetPointIds);
                    break;
                }
                case "RP1": {
                    this.offsetInputCoor.add(this.safeGetEastNorth(r));
                    break;
                }
                case "RP2": {
                    this.offsetReferCoor.add(this.safeGetEastNorth(r));
                    break;
                }
                case "CPC": {
                    this.nControlPoints = this.safeGetInt(r);
                    break;
                }
                case "CPI": {
                    this.safeGet(r, this.controlPointIds);
                    break;
                }
                case "CP1": {
                    this.controlInputCoor.add(this.safeGetEastNorth(r));
                    break;
                }
                case "CP2": {
                    this.controlReferCoor.add(this.safeGetEastNorth(r));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && Offset.areSameSize(this.nOffsetPoints, this.offsetPointIds, this.offsetInputCoor, this.offsetReferCoor) && Offset.areSameSize(this.nControlPoints, this.controlPointIds, this.controlInputCoor, this.controlReferCoor);
        }
    }

    public static class CoorReference
    extends GeoBlock {
        ReferenceType type;
        String name = "";
        String code = "";
        int nDim;
        AltitudeSystem altitudeSystem;
        AltitudeSystemType altitudeSystemType;
        String altitudeSystemName = "";
        String altitudeSystemCode = "";
        String unitHorizontal = "";
        String unitVertical = "";

        CoorReference(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "RET": {
                    this.safeGet(r, (String s) -> {
                        this.type = ReferenceType.of(s);
                    });
                    break;
                }
                case "REN": {
                    this.safeGetAndLog(r, s -> {
                        this.name = this.name + s;
                    }, I18n.tr((String)"Projection", (Object[])new Object[0]));
                    break;
                }
                case "REL": {
                    this.safeGetAndLog(r, s -> {
                        this.code = this.code + s;
                    }, I18n.tr((String)"Projection", (Object[])new Object[0]));
                    break;
                }
                case "DIM": {
                    this.nDim = this.safeGetInt(r);
                    break;
                }
                case "ALS": {
                    this.altitudeSystem = AltitudeSystem.of(this.safeGetInt(r));
                    break;
                }
                case "ALT": {
                    this.altitudeSystemType = AltitudeSystemType.of(this.safeGetInt(r));
                    break;
                }
                case "ALN": {
                    this.safeGet(r, (String s) -> {
                        this.altitudeSystemName = this.altitudeSystemName + s;
                    });
                    break;
                }
                case "ALL": {
                    this.safeGet(r, (String s) -> {
                        this.altitudeSystemCode = this.altitudeSystemCode + s;
                    });
                    break;
                }
                case "UNH": {
                    this.safeGet(r, (String s) -> {
                        this.unitHorizontal = this.unitHorizontal + s;
                    });
                    break;
                }
                case "UNV": {
                    this.safeGet(r, (String s) -> {
                        this.unitVertical = this.unitVertical + s;
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && CoorReference.areNotNull(new Object[]{this.type, this.altitudeSystem}) && CoorReference.areNotEmpty(this.code, this.unitHorizontal) && (this.nDim == 2 || this.nDim == 3 && CoorReference.areNotEmpty(this.unitVertical)) && (AltitudeSystem.THREE_DIM_OR_NO_ALTITUDE == this.altitudeSystem || CoorReference.areNotNull(new Object[]{this.altitudeSystemType, this.altitudeSystemName, this.altitudeSystemCode}));
        }

        public final ReferenceType getReferenceType() {
            return this.type;
        }

        public final String getReferenceName() {
            return this.name;
        }

        public final String getReferenceCode() {
            return this.code;
        }

        public final int getNumberOfDimensions() {
            return this.nDim;
        }

        public final AltitudeSystem getAltitudeSystem() {
            return this.altitudeSystem;
        }

        public final String getUnitHorizontal() {
            return this.unitHorizontal;
        }

        public final String getUnitVertical() {
            return this.unitVertical;
        }

        public final Projection getProjection() {
            Enum ref;
            switch (this.type.code) {
                case "CAR": {
                    ref = CartesianReference.valueOf(this.code);
                    break;
                }
                case "GEO": {
                    ref = GeographicReference.valueOf(this.code);
                    break;
                }
                case "MAP": {
                    ref = ProjectedReference.valueOf(this.code);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.code);
                }
            }
            return Projections.getProjectionByCode((String)ref.getEpsgCode());
        }

        static enum ProjectedReference implements Reference
        {
            LAMB1("EPSG:27561"),
            LAMB2("EPSG:27562"),
            LAMB3("EPSG:27563"),
            LAMB4("EPSG:27564"),
            LAMB1C("EPSG:27571"),
            LAMB2C("EPSG:27572"),
            LAMB3C("EPSG:27573"),
            LAMB4C("EPSG:27574"),
            LAMBE("EPSG:27572"),
            LAMB93("EPSG:2154"),
            UTM30("EPSG:23030"),
            UTM31("EPSG:23031"),
            UTM32("EPSG:23032"),
            UTM30W72("EPSG:32230"),
            UTM31W72("EPSG:32231"),
            UTM32W72("EPSG:32232"),
            UTM30W84("EPSG:32630"),
            UTM31W84("EPSG:32631"),
            UTM32W84("EPSG:32632"),
            REUN47GAUSSL("EPSG:3727"),
            MART38UTM20("EPSG:2973"),
            GUAD48UTM20("EPSG:2970"),
            CSG67UTM21("EPSG:3312"),
            CSG67UTM22("EPSG:2971"),
            MAYO50UTM38S("EPSG:2980"),
            STPM50UTM21("EPSG:2987");

            final String epsg;

            private ProjectedReference(String epsg) {
                this.epsg = epsg;
            }

            @Override
            public String getEpsgCode() {
                return this.epsg;
            }
        }

        static enum GeographicReference implements Reference
        {
            NTFG("EPSG:4275"),
            NTFP("EPSG:4807"),
            ED50G("EPSG:4230"),
            WGS72G("EPSG:4322"),
            WGS84G("EPSG:4326"),
            REUN47GEO("EPSG:4626"),
            MART38GEO("EPSG:4625"),
            GUAD48GEO("EPSG:4622"),
            CSG67GEO("EPSG:4623"),
            MAYO50GEO("EPSG:4632"),
            STPM50GEO("EPSG:4638");

            final String epsg;

            private GeographicReference(String epsg) {
                this.epsg = epsg;
            }

            @Override
            public String getEpsgCode() {
                return this.epsg;
            }
        }

        static enum CartesianReference implements Reference
        {
            NTF("EPSG:4275"),
            ED50("EPSG:4230"),
            WGS72("EPSG:4322"),
            WGS84("EPSG:4326"),
            REUN47("EPSG:4626"),
            MART38("EPSG:4625"),
            GUAD48("EPSG:4622"),
            CSG67("EPSG:4623"),
            MAYO50("EPSG:4632"),
            STPM50("EPSG:4638");

            final String epsg;

            private CartesianReference(String epsg) {
                this.epsg = epsg;
            }

            @Override
            public String getEpsgCode() {
                return this.epsg;
            }
        }

        static interface Reference {
            public String getEpsgCode();
        }

        static enum AltitudeSystemType {
            TERRESTRIAL(1),
            BATHYMETRIC(2);

            final int code;

            private AltitudeSystemType(int code) {
                this.code = code;
            }

            public static AltitudeSystemType of(int code) {
                for (AltitudeSystemType s : AltitudeSystemType.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }

        static enum AltitudeSystem {
            TWO_DIM_PLUS_ALTITUDE(1),
            THREE_DIM_OR_NO_ALTITUDE(2);

            final int code;

            private AltitudeSystem(int code) {
                this.code = code;
            }

            public static AltitudeSystem of(int code) {
                for (AltitudeSystem s : AltitudeSystem.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }

        static enum ReferenceType {
            CARTESIAN("CAR"),
            GEOGRAPHIC("GEO"),
            PROJECTED("MAP");

            final String code;

            private ReferenceType(String code) {
                this.code = code;
            }

            public static ReferenceType of(String code) {
                for (ReferenceType r : ReferenceType.values()) {
                    if (!r.code.equals(code)) continue;
                    return r;
                }
                throw new IllegalArgumentException(code);
            }
        }
    }

    static abstract class GeoBlock
    extends EdigeoFileTHF.ChildBlock {
        GeoBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }
}

