/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;

public class IntersectingMatch
extends SearchCompiler.UnaryMatch {
    private Collection<Way> intersecting = null;
    boolean all;

    public IntersectingMatch(SearchCompiler.Match match, boolean all) {
        super(match);
        this.all = all;
    }

    private void init(boolean all) {
        HashSet<Way> matchedWays = new HashSet<Way>();
        Collection allWays = MainApplication.getLayerManager().getEditDataSet().getWays();
        for (Way way : allWays) {
            if (!this.match.match((OsmPrimitive)way)) continue;
            matchedWays.add(way);
        }
        HashSet<Way> newWays = new HashSet<Way>();
        if (all) {
            NodeWayUtils.addWaysIntersectingWaysRecursively(allWays, matchedWays, newWays);
        } else {
            NodeWayUtils.addWaysIntersectingWays(allWays, matchedWays, newWays);
        }
        this.intersecting = newWays;
    }

    public boolean match(OsmPrimitive osm) {
        if (this.intersecting == null) {
            this.init(this.all);
        }
        if (osm instanceof Way) {
            return this.intersecting.contains(osm);
        }
        return false;
    }
}

