/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Logging;

public final class OsmDownloader {
    private OsmDownloader() {
    }

    public static void downloadOapi(String oapiReq) {
        if (oapiReq != null) {
            try {
                String oapiServer = Main.pref.get("opendata.oapi", "http://www.overpass-api.de/api/interpreter?");
                Logging.info((String)oapiReq);
                String oapiReqEnc = URLEncoder.encode(oapiReq, "UTF-8");
                MainApplication.getMenu().openLocation.openUrl(false, oapiServer + "data=" + oapiReqEnc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadXapi(Collection<String> xapiReqs) {
        if (xapiReqs != null) {
            String xapiServer = Main.pref.get("opendata.xapi", "http://www.overpass-api.de/api/xapi?");
            for (String xapiReq : xapiReqs) {
                MainApplication.getMenu().openLocation.openUrl(false, xapiServer + xapiReq);
            }
        }
    }
}

