/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.data;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikipediaApp;

public class WikipediaEntry
implements Comparable<WikipediaEntry> {
    public final String lang;
    public final String article;
    public final LatLon coordinate;
    private Boolean wiwosmStatus;

    public WikipediaEntry(String lang, String article) {
        this(lang, article, null);
    }

    public WikipediaEntry(String lang, String article, LatLon coordinate) {
        this.lang = lang;
        this.article = article;
        this.coordinate = coordinate;
    }

    static WikipediaEntry parseFromUrl(String url) {
        if (url == null) {
            return null;
        }
        url = Utils.decodeUrl((String)url);
        Matcher m = Pattern.compile("(https?:)?//(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
        if (!m.matches()) {
            return null;
        }
        return new WikipediaEntry(m.group(2), m.group(3));
    }

    public static WikipediaEntry parseTag(String key, String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("http")) {
            return WikipediaEntry.parseFromUrl(value);
        }
        if (value.contains(":")) {
            String[] item = Utils.decodeUrl((String)value).split(":", 2);
            String article = item[1].replace("_", " ");
            return new WikipediaEntry(item[0], article);
        }
        if (key.startsWith("wikipedia:")) {
            String[] item;
            String lang = key.split(":", 2)[1];
            String article = item[(item = Utils.decodeUrl((String)value).split(":", 2)).length == 2 ? 1 : 0].replace("_", " ");
            return new WikipediaEntry(lang, article);
        }
        return null;
    }

    public Tag createWikipediaTag() {
        return new Tag("wikipedia", this.lang + ":" + this.article);
    }

    public void setWiwosmStatus(Boolean wiwosmStatus) {
        this.wiwosmStatus = wiwosmStatus;
    }

    public Boolean getWiwosmStatus() {
        return this.wiwosmStatus;
    }

    public String getBrowserUrl() {
        return WikipediaApp.forLanguage(this.lang).getSiteUrl() + "/wiki/" + Utils.encodeUrl((String)this.article.replace(" ", "_"));
    }

    public String getLabelText() {
        return this.article;
    }

    public String getSearchText() {
        return this.article;
    }

    public String toString() {
        return this.article;
    }

    @Override
    public int compareTo(WikipediaEntry o) {
        return AlphanumComparator.getInstance().compare(this.article, o.article);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikipediaEntry that = (WikipediaEntry)o;
        return Objects.equals(this.lang, that.lang) && Objects.equals(this.article, that.article);
    }

    public int hashCode() {
        return Objects.hash(this.lang, this.article);
    }
}

