/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.CRNCountRecord;
import org.apache.poi.hssf.record.CRNRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternalNameRecord;
import org.apache.poi.hssf.record.NameCommentRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.SupBookRecord;

final class LinkTable {
    private final ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List<NameRecord> _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;

    public LinkTable(List<Record> list, int n, WorkbookRecordList workbookRecordList, Map<String, NameCommentRecord> map) {
        this._workbookRecordList = workbookRecordList;
        RecordStream recordStream = new RecordStream(list, n);
        ArrayList<ExternalBookBlock> arrayList = new ArrayList<ExternalBookBlock>();
        while (recordStream.peekNextClass() == SupBookRecord.class) {
            arrayList.add(new ExternalBookBlock(recordStream));
        }
        this._externalBookBlocks = new ExternalBookBlock[arrayList.size()];
        arrayList.toArray(this._externalBookBlocks);
        arrayList.clear();
        this._externSheetRecord = this._externalBookBlocks.length > 0 ? (recordStream.peekNextClass() != ExternSheetRecord.class ? null : LinkTable.readExtSheetRecord(recordStream)) : null;
        this._definedNames = new ArrayList<NameRecord>();
        while (true) {
            StandardRecord standardRecord;
            Class<? extends Record> clazz;
            if ((clazz = recordStream.peekNextClass()) == NameRecord.class) {
                standardRecord = (NameRecord)recordStream.getNext();
                this._definedNames.add((NameRecord)standardRecord);
                continue;
            }
            if (clazz != NameCommentRecord.class) break;
            standardRecord = (NameCommentRecord)recordStream.getNext();
            map.put(((NameCommentRecord)standardRecord).getNameText(), (NameCommentRecord)standardRecord);
        }
        this._recordCount = recordStream.getCountRead();
        this._workbookRecordList.getRecords().addAll(list.subList(n, n + this._recordCount));
    }

    private static ExternSheetRecord readExtSheetRecord(RecordStream recordStream) {
        ArrayList<ExternSheetRecord> arrayList = new ArrayList<ExternSheetRecord>(2);
        while (recordStream.peekNextClass() == ExternSheetRecord.class) {
            arrayList.add((ExternSheetRecord)recordStream.getNext());
        }
        int n = arrayList.size();
        if (n < 1) {
            throw new RuntimeException("Expected an EXTERNSHEET record but got (" + recordStream.peekNextClass().getName() + ")");
        }
        if (n == 1) {
            return (ExternSheetRecord)arrayList.get(0);
        }
        ExternSheetRecord[] externSheetRecordArray = new ExternSheetRecord[n];
        arrayList.toArray(externSheetRecordArray);
        return ExternSheetRecord.combine(externSheetRecordArray);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int n) {
        return this._definedNames.get(n);
    }

    public String[] getExternalBookAndSheetName(int n) {
        int n2 = this._externSheetRecord.getExtbookIndexFromRefIndex(n);
        SupBookRecord supBookRecord = this._externalBookBlocks[n2].getExternalBookRecord();
        if (!supBookRecord.isExternalReferences()) {
            return null;
        }
        int n3 = this._externSheetRecord.getFirstSheetIndexFromRefIndex(n);
        String string = null;
        if (n3 >= 0) {
            string = supBookRecord.getSheetNames()[n3];
        }
        return new String[]{supBookRecord.getURL(), string};
    }

    public int getIndexToInternalSheet(int n) {
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(n);
    }

    public String resolveNameXText(int n, int n2) {
        int n3 = this._externSheetRecord.getExtbookIndexFromRefIndex(n);
        return this._externalBookBlocks[n3].getNameText(n2);
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private final ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        public ExternalBookBlock(RecordStream recordStream) {
            this._externalBookRecord = (SupBookRecord)recordStream.getNext();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (recordStream.peekNextClass() == ExternalNameRecord.class) {
                arrayList.add(recordStream.getNext());
            }
            this._externalNameRecords = new ExternalNameRecord[arrayList.size()];
            arrayList.toArray(this._externalNameRecords);
            arrayList.clear();
            while (recordStream.peekNextClass() == CRNCountRecord.class) {
                arrayList.add(new CRNBlock(recordStream));
            }
            this._crnBlocks = new CRNBlock[arrayList.size()];
            arrayList.toArray(this._crnBlocks);
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int n) {
            return this._externalNameRecords[n].getText();
        }
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;

        public CRNBlock(RecordStream recordStream) {
            this._countRecord = (CRNCountRecord)recordStream.getNext();
            int n = this._countRecord.getNumberOfCRNs();
            CRNRecord[] cRNRecordArray = new CRNRecord[n];
            for (int i = 0; i < cRNRecordArray.length; ++i) {
                cRNRecordArray[i] = (CRNRecord)recordStream.getNext();
            }
        }
    }
}

