/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import com.sun.media.jai.operator.ImageReadDescriptor;
import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

public class MultiLevelROIRaster
implements MultiLevelROI {
    private static final Logger LOGGER = Logging.getLogger(MultiLevelROIRaster.class);
    private File file;
    private Geometry footprint;
    private ReferencedEnvelope env;
    private MaskOverviewProvider maskOvrProvider;

    public MultiLevelROIRaster(DatasetLayout layout, File file, SimpleFeature sf) throws IOException {
        this.file = file;
        Geometry geo = (Geometry)sf.getDefaultGeometry();
        this.env = JTS.toEnvelope(geo);
        this.footprint = JTS.toGeometry(this.env);
        this.maskOvrProvider = new MaskOverviewProvider(layout, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROI getTransformedROI(AffineTransform at, int imageIndex, Rectangle imgBounds, ImageReadParam params, ReadType readType) {
        MaskOverviewProvider.MaskInfo info = this.maskOvrProvider.getMaskInfo(imageIndex, imgBounds, params);
        File inFile = info.file;
        int index = info.index;
        if (inFile == null) {
            throw new IllegalArgumentException("Unable to load Raster Footprint for granule: " + this.file.getAbsolutePath());
        }
        URL granuleUrl = URLs.fileToUrl(inFile);
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = info.streamSpi.createInputStreamInstance(granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            reader = info.readerSpi.createReaderInstance();
            reader.setInput(inStream, false, false);
            RenderedImage raster = null;
            if (readType.equals((Object)ReadType.DIRECT_READ)) {
                raster = reader.read(index, info.readParameters);
            } else {
                inStream.seek(0L);
                raster = ImageReadDescriptor.create(inStream, index, false, false, false, null, null, info.readParameters, reader, null);
            }
            ROI rOI = MaskOverviewProvider.scaleROI(raster, imgBounds);
            return rOI;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            block25: {
                block24: {
                    if (readType != ReadType.JAI_IMAGEREAD && reader != null) {
                        try {
                            reader.dispose();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block24;
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                if (readType != ReadType.JAI_IMAGEREAD && inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block25;
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.env.isEmpty();
    }

    @Override
    public Geometry getFootprint() {
        return this.footprint;
    }
}

