/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileImageInputStreamExtFileChannelImpl
extends ImageInputStreamImpl
implements FileImageInputStreamExt {
    private File file;
    private FileChannelImageInputStream fileChannelInputStream;

    @Override
    public byte readByte() throws IOException {
        return this.fileChannelInputStream.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.fileChannelInputStream.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.fileChannelInputStream.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.fileChannelInputStream.readFloat();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fileChannelInputStream.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.fileChannelInputStream.readFully(b);
    }

    @Override
    public int readInt() throws IOException {
        return this.fileChannelInputStream.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.fileChannelInputStream.readLine();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fileChannelInputStream.getByteOrder();
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.fileChannelInputStream.getStreamPosition();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.fileChannelInputStream.read(b);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        return this.fileChannelInputStream.skipBytes(n);
    }

    @Override
    public long readLong() throws IOException {
        return this.fileChannelInputStream.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.fileChannelInputStream.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.fileChannelInputStream.readUnsignedByte();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.fileChannelInputStream.readUnsignedInt();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.fileChannelInputStream.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.fileChannelInputStream.readUTF();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.fileChannelInputStream.setByteOrder(byteOrder);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.fileChannelInputStream.skipBytes(n);
    }

    public FileImageInputStreamExtFileChannelImpl(File f) throws FileNotFoundException, IOException {
        this(f, -1);
    }

    public FileImageInputStreamExtFileChannelImpl(File f, int bufferSize) throws IOException {
        if (f == null) {
            throw new NullPointerException("f == null!");
        }
        StringBuilder buff = new StringBuilder("Invalid input file provided");
        if (!f.exists() || f.isDirectory()) {
            buff.append("exists: ").append(f.exists()).append("\n");
            buff.append("isDirectory: ").append(f.isDirectory()).append("\n");
            throw new FileNotFoundException(buff.toString());
        }
        if (!f.exists() || f.isDirectory() || !f.canRead()) {
            buff.append("canRead: ").append(f.canRead()).append("\n");
            throw new IOException(buff.toString());
        }
        this.file = f;
        FileChannel fc = new FileInputStream(f).getChannel();
        this.fileChannelInputStream = new FileChannelImageInputStream(fc);
        this.fileChannelInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int read() throws IOException {
        return this.fileChannelInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fileChannelInputStream.read(b, off, len);
    }

    @Override
    public long length() {
        return this.fileChannelInputStream.length();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.fileChannelInputStream.seek(pos);
    }

    @Override
    public void close() throws IOException {
        this.fileChannelInputStream.close();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "FileImageInputStreamExtFileChannelImpl which points to " + this.file.toString();
    }

    @Override
    public File getTarget() {
        return this.file;
    }

    @Override
    public Class<File> getBinding() {
        return File.class;
    }
}

