/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.actions.LoadPictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.actions.LoadPictureCalibrationFromWorldAction;
import org.openstreetmap.josm.plugins.piclayer.actions.ResetCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.actions.SavePictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.actions.SavePictureCalibrationToWorldAction;
import org.openstreetmap.josm.plugins.piclayer.transform.PictureTransform;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmDecimalFormatSymbolsProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class PicLayerAbstract
extends Layer {
    private static int imageCounter = 0;
    protected Image image = null;
    private static Image pinTiledImage;
    protected double initialImageScale = 1.0;
    private Icon layerIcon = null;
    private boolean drawMarkers = true;
    protected PictureTransform transformer;
    private static final String POSITION_X = "POSITION_X";
    private static final String POSITION_Y = "POSITION_Y";
    private static final String ANGLE = "ANGLE";
    private static final String INITIAL_SCALE = "INITIAL_SCALE";
    private static final String SCALEX = "SCALEX";
    private static final String SCALEY = "SCALEY";
    private static final String SHEARX = "SHEARX";
    private static final String SHEARY = "SHEARY";
    private static final String MATRIXm00 = "M00";
    private static final String MATRIXm01 = "M01";
    private static final String MATRIXm10 = "M10";
    private static final String MATRIXm11 = "M11";
    private static final String MATRIXm02 = "M02";
    private static final String MATRIXm12 = "M12";
    private static final int pinAnchorX = 31;
    private static final int pinAnchorY = 31;
    private static final int[] pinTileOffsetX;
    private static final int[] pinTileOffsetY;
    private static final int pinWidth = 64;
    private static final int pinHeight = 64;
    protected final Projection projection;

    public void setDrawPoints(boolean value) {
        this.drawMarkers = value;
    }

    public PictureTransform getTransformer() {
        return this.transformer;
    }

    public PicLayerAbstract() {
        super("PicLayer #" + imageCounter);
        ++imageCounter;
        this.layerIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(((Object)((Object)this)).getClass().getResource("/images/layericon.png")));
        if (pinTiledImage == null) {
            pinTiledImage = new ImageIcon(Toolkit.getDefaultToolkit().createImage(((Object)((Object)this)).getClass().getResource("/images/v6_64.png"))).getImage();
        }
        this.projection = Main.getProjection();
    }

    public void initialize() throws IOException {
        this.transformer = new PictureTransform();
        if (MainApplication.getMap() == null || MainApplication.getMap().mapView == null) {
            throw new IOException(I18n.tr((String)"Could not find the map object.", (Object[])new Object[0]));
        }
        EastNorth center = MainApplication.getMap().mapView.getCenter();
        this.transformer.setImagePosition(new EastNorth(center.east(), center.north()));
        this.initialImageScale = MainApplication.getMap().mapView.getDist100Pixel();
        this.image = this.createImage();
        if (this.image == null) {
            throw new IOException(I18n.tr((String)"PicLayer failed to load or import the image.", (Object[])new Object[0]));
        }
        new ImageIcon(this.image).getImage();
        this.lookForCalibration();
    }

    protected abstract Image createImage() throws IOException;

    protected abstract void lookForCalibration() throws IOException;

    public abstract String getPicLayerName();

    public Icon getIcon() {
        return this.layerIcon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{new ResetCalibrationAction(this, this.transformer), Layer.SeparatorLayerAction.INSTANCE, new SavePictureCalibrationAction(this), new LoadPictureCalibrationAction(this), Layer.SeparatorLayerAction.INSTANCE, new SavePictureCalibrationToWorldAction(this), new LoadPictureCalibrationFromWorldAction(this), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this)};
    }

    public String getToolTipText() {
        return this.getPicLayerName();
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.image != null) {
            EastNorth center = mv.getCenter();
            EastNorth leftop = mv.getEastNorth(0, 0);
            double pixel_per_en = (double)mv.getWidth() / 2.0 / (center.east() - leftop.east());
            EastNorth imagePosition = this.transformer.getImagePosition();
            double pic_offset_x = (imagePosition.east() - leftop.east()) * pixel_per_en;
            double pic_offset_y = (leftop.north() - imagePosition.north()) * pixel_per_en;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            double scalex = this.initialImageScale * pixel_per_en / this.getMetersPerEasting(imagePosition) / 100.0;
            double scaley = this.initialImageScale * pixel_per_en / this.getMetersPerNorthing(imagePosition) / 100.0;
            g.scale(scalex, scaley);
            g.transform(this.transformer.getTransform());
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(this.image, -this.image.getWidth(null) / 2, -this.image.getHeight(null) / 2, null);
            if (mv.getLayerManager().getActiveLayer() == this) {
                g.setColor(new Color(0xFF0000));
                g.drawRect(-this.image.getWidth(null) / 2, -this.image.getHeight(null) / 2, this.image.getWidth(null), this.image.getHeight(null));
            }
            if (this.drawMarkers) {
                Graphics2D gPoints = (Graphics2D)g2.create();
                gPoints.translate(pic_offset_x, pic_offset_y);
                gPoints.setColor(Color.RED);
                AffineTransform tr = AffineTransform.getScaleInstance(scalex, scaley);
                tr.concatenate(this.transformer.getTransform());
                for (int i = 0; i < this.transformer.getOriginPoints().size(); ++i) {
                    Point2D trP = tr.transform(this.transformer.getOriginPoints().get(i), null);
                    int x = (int)trP.getX();
                    int y = (int)trP.getY();
                    int dstx = x - 31;
                    int dsty = y - 31;
                    gPoints.drawImage(pinTiledImage, dstx, dsty, dstx + 64, dsty + 64, pinTileOffsetX[i], pinTileOffsetY[i], pinTileOffsetX[i] + 64, pinTileOffsetY[i] + 64, null);
                }
            }
        } else {
            System.out.println("PicLayerAbstract::paint - general drawing error (image is null or Graphics not 2D");
        }
    }

    protected double getMetersPerEasting(EastNorth en) {
        double naturalScale = this.projection.getDefaultZoomInPPD();
        LatLon ll1 = this.projection.eastNorth2latlon(new EastNorth(en.east() - (naturalScale *= 0.01), en.north()));
        LatLon ll2 = this.projection.eastNorth2latlon(new EastNorth(en.east() + naturalScale, en.north()));
        double dist = ll1.greatCircleDistance(ll2) / naturalScale / 2.0;
        return dist;
    }

    private double getMetersPerNorthing(EastNorth en) {
        double naturalScale = this.projection.getDefaultZoomInPPD();
        LatLon ll1 = this.projection.eastNorth2latlon(new EastNorth(en.east(), en.north() - (naturalScale *= 0.01)));
        LatLon ll2 = this.projection.eastNorth2latlon(new EastNorth(en.east(), en.north() + naturalScale));
        double dist = ll1.greatCircleDistance(ll2) / naturalScale / 2.0;
        return dist;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
        if (this.image == null) {
            return;
        }
        String projcode = this.projection.toCode();
        if (projcode.equals("EPSG:4326")) {
            return;
        }
        EastNorth center = this.transformer.getImagePosition();
        double w = this.image.getWidth(null);
        double h = this.image.getHeight(null);
        double diag_pix = Math.sqrt(w * w + h * h);
        double diag_m = diag_pix / 100.0 * this.initialImageScale;
        AffineTransform trans = this.transformer.getTransform();
        double factor = Math.max(trans.getScaleX(), trans.getScaleY());
        double offset = factor * diag_m / 2.0;
        EastNorth topleft = center.add(-offset, -offset);
        EastNorth bottomright = center.add(offset, offset);
        arg0.visit(topleft);
        arg0.visit(bottomright);
    }

    public void saveCalibration(Properties props) {
        double[] matrix = new double[6];
        this.transformer.getTransform().getMatrix(matrix);
        props.put(MATRIXm00, Double.toString(matrix[0]));
        props.put(MATRIXm01, Double.toString(matrix[1]));
        props.put(MATRIXm10, Double.toString(matrix[2]));
        props.put(MATRIXm11, Double.toString(matrix[3]));
        props.put(MATRIXm02, Double.toString(matrix[4]));
        props.put(MATRIXm12, Double.toString(matrix[5]));
        props.put(POSITION_X, Double.toString(this.transformer.getImagePosition().getX()));
        props.put(POSITION_Y, Double.toString(this.transformer.getImagePosition().getY()));
        props.put(INITIAL_SCALE, Double.toString(this.initialImageScale));
        this.transformer.resetModified();
    }

    public void loadCalibration(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        this.loadCalibration(props);
    }

    public void loadCalibration(Properties props) {
        AffineTransform transform;
        double pos_x = Double.valueOf(props.getProperty(POSITION_X, "0"));
        double pos_y = Double.valueOf(props.getProperty(POSITION_Y, "0"));
        EastNorth imagePosition = new EastNorth(pos_x, pos_y);
        this.transformer.setImagePosition(imagePosition);
        this.initialImageScale = Double.valueOf(props.getProperty(INITIAL_SCALE, "1"));
        if (props.containsKey(SCALEX)) {
            double angle = Double.valueOf(props.getProperty(ANGLE, "0"));
            double scale_x = Double.valueOf(props.getProperty(SCALEX, "1"));
            double scale_y = Double.valueOf(props.getProperty(SCALEY, "1"));
            double shear_x = Double.valueOf(props.getProperty(SHEARX, "0"));
            double shear_y = Double.valueOf(props.getProperty(SHEARY, "0"));
            transform = AffineTransform.getRotateInstance(angle / 180.0 * Math.PI);
            transform.scale(scale_x, scale_y);
            transform.shear(shear_x, shear_y);
        } else {
            double[] matrix = new double[]{JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm00, "1")), JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm01, "0")), JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm10, "0")), JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm11, "1")), JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm02, "0")), JosmDecimalFormatSymbolsProvider.parseDouble((String)props.getProperty(MATRIXm12, "0"))};
            transform = new AffineTransform(matrix);
        }
        this.transformer.resetCalibration();
        this.transformer.getTransform().concatenate(transform);
        this.invalidate();
    }

    public void loadWorldfile(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(reader);){
            double[] e = new double[6];
            for (int i = 0; i < 6; ++i) {
                String line = br.readLine();
                if (line == null) {
                    throw new IOException("Unable to read line " + (i + 1));
                }
                e[i] = JosmDecimalFormatSymbolsProvider.parseDouble((String)line);
            }
            double sx = e[0];
            double ry = e[1];
            double rx = e[2];
            double sy = e[3];
            double dx = e[4];
            double dy = e[5];
            int w = this.image.getWidth(null);
            int h = this.image.getHeight(null);
            EastNorth imagePosition = new EastNorth(dx + (double)(w / 2) * sx + (double)(h / 2) * rx, dy + (double)(w / 2) * ry + (double)(h / 2) * sy);
            double scalex = 100.0 * sx * this.getMetersPerEasting(imagePosition);
            double scaley = -100.0 * sy * this.getMetersPerNorthing(imagePosition);
            double shearx = rx / sx;
            double sheary = ry / sy;
            this.transformer.setImagePosition(imagePosition);
            this.transformer.resetCalibration();
            AffineTransform tr = this.transformer.getTransform();
            tr.scale(scalex, scaley);
            tr.shear(shearx, sheary);
            this.initialImageScale = 1.0;
            this.invalidate();
        }
    }

    public void saveWorldFile(double[] values) {
        double[] matrix = new double[6];
        this.transformer.getTransform().getMatrix(matrix);
        double a00 = matrix[0];
        double a01 = matrix[2];
        double a02 = matrix[4];
        double a10 = matrix[1];
        double a11 = matrix[3];
        double a12 = matrix[5];
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        EastNorth imagePosition = this.transformer.getImagePosition();
        double qx = this.initialImageScale / 100.0 / this.getMetersPerEasting(imagePosition);
        double qy = -this.initialImageScale / 100.0 / this.getMetersPerNorthing(imagePosition);
        double sx = qx * a00;
        double sy = qy * a11;
        double rx = qx * a01;
        double ry = qy * a10;
        double dx = imagePosition.getX() + qx * a02 - sx * (double)w / 2.0 - rx * (double)h / 2.0;
        double dy = imagePosition.getY() + qy * a12 - ry * (double)w / 2.0 - sy * (double)h / 2.0;
        values[0] = sx;
        values[1] = ry;
        values[2] = rx;
        values[3] = sy;
        values[4] = dx;
        values[5] = dy;
    }

    public Point2D transformPoint(Point p) throws NoninvertibleTransformException {
        EastNorth center = MainApplication.getMap().mapView.getCenter();
        EastNorth leftop = MainApplication.getMap().mapView.getEastNorth(0, 0);
        double pixel_per_en = (double)MainApplication.getMap().mapView.getWidth() / 2.0 / (center.east() - leftop.east());
        EastNorth imageCenter = this.transformer.getImagePosition();
        double pic_offset_x = (imageCenter.east() - leftop.east()) * pixel_per_en;
        double pic_offset_y = (leftop.north() - imageCenter.north()) * pixel_per_en;
        AffineTransform pointTrans = AffineTransform.getTranslateInstance(pic_offset_x, pic_offset_y);
        double scalex = this.initialImageScale * pixel_per_en / this.getMetersPerEasting(imageCenter) / 100.0;
        double scaley = this.initialImageScale * pixel_per_en / this.getMetersPerNorthing(imageCenter) / 100.0;
        pointTrans.scale(scalex, scaley);
        pointTrans.concatenate(this.transformer.getTransform());
        Point2D result = pointTrans.inverseTransform(p, null);
        return result;
    }

    public void movePictureBy(double x, double y) {
        this.transformer.setImagePosition(this.transformer.getImagePosition().add(x, y));
    }

    public void rotatePictureBy(double angle) {
        try {
            MapView mapView = MainApplication.getMap().mapView;
            Point2D trans = this.transformPoint(new Point(mapView.getWidth() / 2, mapView.getHeight() / 2));
            this.transformer.concatenateTransformPoint(AffineTransform.getRotateInstance(angle), trans);
        }
        catch (NoninvertibleTransformException e) {
            Logging.error((Throwable)e);
        }
    }

    public void scalePictureBy(double scalex, double scaley) {
        try {
            MapView mapView = MainApplication.getMap().mapView;
            Point2D trans = this.transformPoint(new Point(mapView.getWidth() / 2, mapView.getHeight() / 2));
            this.transformer.concatenateTransformPoint(AffineTransform.getScaleInstance(scalex, scaley), trans);
        }
        catch (NoninvertibleTransformException e) {
            Logging.error((Throwable)e);
        }
    }

    public void shearPictureBy(double shx, double shy) {
        try {
            MapView mapView = MainApplication.getMap().mapView;
            Point2D trans = this.transformPoint(new Point(mapView.getWidth() / 2, mapView.getHeight() / 2));
            this.transformer.concatenateTransformPoint(AffineTransform.getShearInstance(shx, shy), trans);
        }
        catch (NoninvertibleTransformException e) {
            Logging.error((Throwable)e);
        }
    }

    public void resetCalibration() {
        this.transformer.resetCalibration();
    }

    public Point2D findSelectedPoint(Point point) {
        if (this.image == null) {
            return null;
        }
        Point2D selected = null;
        try {
            Point2D pressed = this.transformPoint(point);
            double mindist = 10.0;
            for (Point2D p : this.transformer.getOriginPoints()) {
                if (!(p.distance(pressed) < mindist)) continue;
                selected = p;
                mindist = p.distance(pressed);
            }
            return selected;
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return selected;
        }
    }

    static {
        pinTileOffsetX = new int[]{74, 0, 74, 0};
        pinTileOffsetY = new int[]{0, 74, 74, 0};
    }
}

