/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import java.util.LinkedList;

public class History {
    private final LinkedList<String> historyList;
    private final int maxLen;
    private int num = 0;

    public History(int len) {
        this.maxLen = len;
        this.historyList = new LinkedList();
    }

    public void addItem(String item) {
        if (!item.equals("")) {
            String prevItem = this.historyList.peekFirst();
            if (prevItem == null) {
                this.historyList.addFirst(item);
            } else if (!prevItem.equalsIgnoreCase(item)) {
                this.historyList.addFirst(item);
            }
            if (this.historyList.size() > this.maxLen) {
                this.historyList.removeLast();
            }
        }
        this.num = -1;
    }

    public String getPrevItem() {
        ++this.num;
        if (this.num >= this.historyList.size()) {
            this.num = this.historyList.size() - 1;
        }
        if (this.num < 0) {
            this.num = -1;
            return "";
        }
        return this.historyList.get(this.num);
    }

    public String getLastItem() {
        if (this.historyList.size() > 0) {
            return this.historyList.get(0);
        }
        return "";
    }

    public String getNextItem() {
        --this.num;
        if (this.num < 0) {
            this.num = -1;
            return "";
        }
        return this.historyList.get(this.num);
    }
}

