/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.JunctionChecker.ChannelDiGraphLayer;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;

public class JunctionCheckerMapMode
extends MapMode
implements MainLayerManager.ActiveLayerChangeListener {
    MapFrame frame;
    Point pointPressed;
    ChannelDiGraphLayer layer;
    Rectangle oldRect;
    ChannelDiGraph digraph;
    private static final long serialVersionUID = 3442408951505263850L;

    public JunctionCheckerMapMode(String name, String desc) {
        super(name, "junctionchecker.png", desc, Cursor.getPredefinedCursor(1));
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        Layer newLayer = MainApplication.getLayerManager().getActiveLayer();
        if (newLayer instanceof ChannelDiGraphLayer) {
            this.layer = (ChannelDiGraphLayer)newLayer;
        }
    }

    public void setFrame(MapFrame newFrame) {
        this.frame = newFrame;
    }

    public void mousePressed(MouseEvent e) {
        this.pointPressed = new Point(e.getPoint());
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.paintRect(this.pointPressed, e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        boolean shift;
        if (e.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        this.digraph.ereaseJunctioncandidate();
        Point pointReleased = e.getPoint();
        Rectangle r = this.createRect(pointReleased, this.pointPressed);
        boolean bl = shift = (e.getModifiers() & 1) != 0;
        if (!shift) {
            this.digraph.ereaseSelectedChannels();
        }
        if (this.layer != null && this.digraph != null) {
            LatLon lefttop = MainApplication.getMap().mapView.getLatLon(r.x + r.width, r.y + r.height);
            LatLon rightbottom = MainApplication.getMap().mapView.getLatLon(r.x, r.y);
            this.digraph.detectSelectedChannels(rightbottom.lon(), rightbottom.lat(), lefttop.lon(), lefttop.lat());
        }
        this.oldRect = null;
        MainApplication.getMap().mapView.repaint();
    }

    public Rectangle createRect(Point p1, Point p2) {
        int h;
        int w;
        int y;
        int x;
        if (p1.x == p2.x && p1.y == p2.y) {
            x = p1.x - 1;
            y = p1.y - 1;
            w = 3;
            h = 3;
        } else {
            if (p1.x < p2.x) {
                x = p1.x;
                w = p2.x - p1.x;
            } else {
                x = p2.x;
                w = p1.x - p2.x;
            }
            if (p1.y < p2.y) {
                y = p1.y;
                h = p2.y - p1.y;
            } else {
                y = p2.y;
                h = p1.y - p2.y;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    private void paintRect(Point p1, Point p2) {
        if (this.frame != null) {
            Graphics g = this.frame.getGraphics();
            Rectangle r = this.oldRect;
            if (r != null) {
                g.setXORMode(Color.BLACK);
                g.setColor(Color.WHITE);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            g.setXORMode(Color.BLACK);
            g.setColor(Color.WHITE);
            r = this.createRect(p1, p2);
            g.drawRect(r.x, r.y, r.width, r.height);
            this.oldRect = r;
        }
    }

    public ChannelDiGraph getDigraph() {
        return this.digraph;
    }

    public void setDigraph(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public void destroy() {
        super.destroy();
        MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }
}

