/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import java.util.ArrayList;
import java.util.List;

public class EnvironmentFrameWithDerivation
extends EnvironmentFrame {
    Node[] argVars = new Node[8];
    TriplePattern[] matches;

    public EnvironmentFrameWithDerivation(RuleClauseCode clause) {
        super(clause);
        if (clause.getRule() != null) {
            this.matches = new TriplePattern[clause.getRule().bodyLength()];
        }
    }

    public void noteMatch(TriplePattern pattern, int pc) {
        TriplePattern match = pattern;
        int term = this.clause.termIndex(pc);
        if (term >= 0) {
            this.matches[term] = match;
        }
    }

    public Triple getResult() {
        return new Triple(LPInterpreter.deref(this.argVars[0]), LPInterpreter.deref(this.argVars[1]), LPInterpreter.derefPossFunctor(this.argVars[2]));
    }

    public List<Triple> getMatchList() {
        ArrayList<Triple> matchList = new ArrayList<Triple>();
        for (TriplePattern matche : this.matches) {
            matchList.add(LPInterpreter.deref(matche));
        }
        return matchList;
    }

    public void initDerivationRecord(Node[] args) {
        System.arraycopy(args, 0, this.argVars, 0, 8);
    }
}

