/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextP;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsDocument;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetReader;
import org.openstreetmap.josm.tools.Logging;

public class OdsReader
extends SpreadSheetReader {
    private OpenDocument doc;
    private TableTable sheet;
    private List<TableTableRow> rows;
    private int rowIndex;
    private static final String SEP = "TextP:[";

    public OdsReader(SpreadSheetHandler handler) {
        super(handler);
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new OdsReader(handler != null ? handler.getSpreadSheetHandler() : null).parse(in, instance);
    }

    @Override
    protected void initResources(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        try {
            List<TableTable> tables;
            Logging.info((String)"Parsing ODS file");
            this.doc = new OdsDocument(in);
            List<OfficeSpreadsheet> spreadsheets = this.doc.getBody().getOfficeSpreadsheets();
            if (spreadsheets != null && spreadsheets.size() > 0 && (tables = spreadsheets.get(0).getTables()) != null && tables.size() > 0) {
                this.sheet = tables.get(this.getSheetNumber());
                if (this.sheet != null) {
                    this.rows = this.sheet.getRows();
                }
            }
            this.rowIndex = 0;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String[] readLine(ProgressMonitor progressMonitor) throws IOException {
        if (this.rows != null && this.rowIndex < this.rows.size()) {
            TableTableRow row = this.rows.get(this.rowIndex++);
            if (this.rowIndex % 5000 == 0) {
                Logging.info((String)("Lines read: " + this.rowIndex));
            }
            ArrayList<String> result = new ArrayList<String>();
            boolean allFieldsBlank = true;
            for (TableTableCell cell : row.getAllCells()) {
                TextP textP = cell.getTextP();
                String text = textP == null ? "" : textP.toString().replace(SEP, "").replace("]", "").replace("null", "").trim();
                result.add(text);
                if (!allFieldsBlank || text.isEmpty()) continue;
                allFieldsBlank = false;
            }
            return this.rowIndex == 1 || !allFieldsBlank ? result.toArray(new String[0]) : null;
        }
        return null;
    }
}

