/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.turnrestrictions.TurnRestrictionBuilder;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TurnRestrictionLegSplitRequiredError
extends Issue {
    private TurnRestrictionLegRole role;
    private Way from;
    private Way to;
    private Node intersect;

    public TurnRestrictionLegSplitRequiredError(IssuesModel parent, Way from, Way to) {
        super(parent, Severity.ERROR);
        CheckParameterUtil.ensureParameterNotNull((Object)from, (String)"from");
        CheckParameterUtil.ensureParameterNotNull((Object)to, (String)"to");
        this.intersect = TurnRestrictionBuilder.getUniqueCommonNode(from, to);
        if (this.intersect == null) {
            throw new IllegalArgumentException("exactly one intersecting node required");
        }
        this.from = from;
        this.to = to;
        this.role = null;
        this.actions.add(new SplitAction());
    }

    public TurnRestrictionLegSplitRequiredError(IssuesModel parent, TurnRestrictionLegRole role, Way from, Way to, Node intersect) {
        super(parent, Severity.ERROR);
        this.role = role;
        this.from = from;
        this.to = to;
        this.intersect = intersect;
        this.actions.add(new SplitAction());
    }

    @Override
    public String getText() {
        String msg = null;
        if (this.role == null) {
            return I18n.tr((String)"The way <span class=\"object-name\">{0}</span> with role <tt>from</tt> and the way <span class=\"object-name\">{1}</span> with role <tt>to</tt> intersect at node <span class=\"object-name\">{2}</span>. <p> Both ways should be split at the intersecting node.", (Object[])new Object[]{this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.intersect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
        }
        switch (this.role) {
            case FROM: {
                msg = I18n.tr((String)"The way <span class=\"object-name\">{0}</span> with role <tt>{1}</tt> should be split at node <span class=\"object-name\">{2}</span> where it connects to way <span class=\"object-name\">{3}</span>.", (Object[])new Object[]{this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.getOsmRole(), this.intersect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
                break;
            }
            case TO: {
                msg = I18n.tr((String)"The way <span class=\"object-name\">{0}</span> with role <tt>{1}</tt> should be split at node <span class=\"object-name\">{2}</span> where it connects to way <span class=\"object-name\">{3}</span>.", (Object[])new Object[]{this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.getOsmRole(), this.intersect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
            }
        }
        return msg;
    }

    class SplitAction
    extends AbstractAction {
        SplitAction() {
            this.putValue("Name", I18n.tr((String)"Split now", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Split the ways", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitWayCommand result = null;
            if ((TurnRestrictionLegSplitRequiredError.this.role == null || TurnRestrictionLegSplitRequiredError.this.role.equals((Object)TurnRestrictionLegRole.FROM)) && (result = SplitWayCommand.split((Way)TurnRestrictionLegSplitRequiredError.this.from, Collections.singletonList(TurnRestrictionLegSplitRequiredError.this.intersect), Collections.emptyList())) != null) {
                MainApplication.undoRedo.add((Command)result);
            }
            if (TurnRestrictionLegSplitRequiredError.this.role == null || TurnRestrictionLegSplitRequiredError.this.role.equals((Object)TurnRestrictionLegRole.TO)) {
                result = SplitWayCommand.split((Way)TurnRestrictionLegSplitRequiredError.this.to, Collections.singletonList(TurnRestrictionLegSplitRequiredError.this.intersect), Collections.emptyList());
                if (result != null) {
                    MainApplication.undoRedo.add((Command)result);
                }
                if (result == null) {
                    return;
                }
                TurnRestrictionType restrictionType = TurnRestrictionType.fromTagValue(TurnRestrictionLegSplitRequiredError.this.getIssuesModel().getEditorModel().getRestrictionTagValue());
                if (restrictionType == null) {
                    return;
                }
                Way adjustedTo = TurnRestrictionBuilder.selectToWayAfterSplit(TurnRestrictionLegSplitRequiredError.this.from, result.getOriginalWay(), (Way)result.getNewWays().get(0), restrictionType);
                if (adjustedTo == null) {
                    return;
                }
                TurnRestrictionLegSplitRequiredError.this.getIssuesModel().getEditorModel().setTurnRestrictionLeg(TurnRestrictionLegRole.TO, adjustedTo);
                TurnRestrictionLegSplitRequiredError.this.getIssuesModel().getEditorModel().getLayer().data.setSelected(Arrays.asList(TurnRestrictionLegSplitRequiredError.this.from, adjustedTo));
            } else {
                TurnRestrictionLegSplitRequiredError.this.getIssuesModel().getEditorModel().getLayer().data.setSelected(Arrays.asList(TurnRestrictionLegSplitRequiredError.this.from, TurnRestrictionLegSplitRequiredError.this.to));
            }
        }
    }
}

