/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.generate.LinearGraphGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;

    public RingGraphGenerator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        if (this.size < 1) {
            return;
        }
        LinearGraphGenerator linearGraphGenerator = new LinearGraphGenerator(this.size);
        HashMap hashMap = new HashMap();
        linearGraphGenerator.generateGraph(graph, vertexFactory, hashMap);
        Object v = hashMap.get("Start Vertex");
        Object v2 = hashMap.get("End Vertex");
        graph.addEdge(v2, v);
    }
}

