/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.SingleCurvedGeometry;

public class CurvePolygon
extends Polygon
implements CurvedGeometry<Polygon> {
    private static final long serialVersionUID = -6961191502473439328L;
    private double tolerance;

    public CurvePolygon(LinearRing shell, List<LinearRing> holes, GeometryFactory factory, double tolerance) {
        super(shell, holes.toArray(new LinearRing[holes.size()]), factory);
        this.tolerance = tolerance;
    }

    public CurvePolygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory, double tolerance) {
        super(shell, holes, factory);
        this.tolerance = tolerance;
    }

    @Override
    public Polygon linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public Polygon linearize(double tolerance) {
        int numHoles = this.getNumInteriorRing();
        LinearRing shell = this.linearize(tolerance, (LinearRing)this.getExteriorRing());
        LinearRing[] holes = new LinearRing[numHoles];
        for (int k = 0; k < numHoles; ++k) {
            LinearRing hole = (LinearRing)this.getInteriorRingN(k);
            holes[k] = hole = this.linearize(tolerance, hole);
        }
        return this.getFactory().createPolygon(shell, holes);
    }

    private LinearRing linearize(double tolerance, LinearRing hole) {
        if (hole instanceof CurvedGeometry) {
            CurvedGeometry curved = (CurvedGeometry)hole;
            hole = (LinearRing)curved.linearize(tolerance);
        }
        return hole;
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("CURVEPOLYGON ");
        if (this.isEmpty()) {
            sb.append(" EMTPY");
        } else {
            sb.append("(");
            this.writeRing(sb, this.getExteriorRing());
            int holeNum = this.getNumInteriorRing();
            for (int k = 0; k < holeNum; ++k) {
                sb.append(", ");
                LineString component = this.getInteriorRingN(k);
                this.writeRing(sb, component);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private void writeRing(StringBuilder sb, LineString component) {
        if (component instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry curved = (SingleCurvedGeometry)component;
            sb.append(curved.toCurvedText());
        } else {
            sb.append("(");
            CoordinateSequence cs = component.getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                sb.append(cs.getX(i) + " " + cs.getY(i));
                if (i >= cs.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getCoordinatesDimension() {
        return 2;
    }
}

