/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoCharset;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileSCD;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class EdigeoFileVEC
extends EdigeoLotFile<VecBlock<?>> {
    private static final List<Predicate<ObjectBlock>> ignoredObjects = new ArrayList<Predicate<ObjectBlock>>();
    private static final List<Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>>> postProcessors = new ArrayList<Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>>>();

    public static void addIgnoredObject(Predicate<ObjectBlock> predicate) {
        ignoredObjects.add(Objects.requireNonNull(predicate, "predicate"));
    }

    public static void addIgnoredObject(String key, String ... values) {
        EdigeoFileVEC.addIgnoredObject(EdigeoFileVEC.predicate(key, values));
    }

    public static void addIgnoredScdObjects(String ... types) {
        EdigeoFileVEC.addIgnoredObject(o -> Arrays.asList(types).contains(((EdigeoFileSCD.McdObjectDef)o.scdRef).identifier));
    }

    private static Predicate<ObjectBlock> predicate(String key, String ... values) {
        return o -> {
            List<String> vals = Arrays.asList(values);
            for (int i = 0; i < o.nAttributes; ++i) {
                if (!key.equals(((EdigeoFileSCD.McdAttributeDef)o.attributeDefs.get((int)i)).identifier) || !vals.isEmpty() && !vals.contains(o.attributeValues.get(i))) continue;
                return true;
            }
            return false;
        };
    }

    public static void addObjectPostProcessor(BiConsumer<ObjectBlock, OsmPrimitive> consumer, Predicate<ObjectBlock> predicate) {
        postProcessors.add((Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>>)new Pair(Objects.requireNonNull(predicate, "predicate"), Objects.requireNonNull(consumer, "consumer")));
    }

    public static void addObjectPostProcessor(BiConsumer<ObjectBlock, OsmPrimitive> consumer, String key, String ... values) {
        postProcessors.add((Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>>)new Pair(EdigeoFileVEC.predicate(key, values), Objects.requireNonNull(consumer, "consumer")));
    }

    public static void addObjectPostProcessor(String symId, String keyValues) {
        postProcessors.add((Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>>)new Pair(EdigeoFileVEC.predicate("SYM_id", symId), (o, p) -> {
            p.remove("SYM_id");
            for (String tag : keyValues.split(";")) {
                String[] kv = tag.split("=");
                p.put(kv[0], kv[1]);
            }
        }));
    }

    public EdigeoFileVEC(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("PNO", NodeBlock.class);
        this.register("PAR", ArcBlock.class);
        this.register("PFE", FaceBlock.class);
        this.register("FEA", ObjectBlock.class);
        this.register("LNK", RelationBlock.class);
        lot.vec.add(this);
    }

    private static BBox around(LatLon ll) {
        double r = 1.0E-6;
        return new BBox(ll.getX() - 1.0E-6, ll.getY() - 1.0E-6, ll.getX() + 1.0E-6, ll.getY() + 1.0E-6);
    }

    private static Node getNodeAt(DataSet ds, Projection proj, EastNorth en) {
        LatLon ll = proj.eastNorth2latlon(en);
        List nodes = ds.searchNodes(EdigeoFileVEC.around(ll));
        if (nodes.isEmpty()) {
            Node n = new Node(ll);
            ds.addPrimitive((OsmPrimitive)n);
            return n;
        }
        return (Node)nodes.get(0);
    }

    @Override
    EdigeoFileVEC fill(DataSet ds) {
        super.fill(ds);
        Projection proj = this.lot.geo.getCoorReference().getProjection();
        for (ObjectBlock obj : this.getObjects()) {
            Node p2;
            if (ignoredObjects.stream().anyMatch(p -> p.test(obj))) continue;
            switch (((EdigeoFileSCD.McdObjectDef)obj.scdRef).kind) {
                case POINT: {
                    p2 = EdigeoFileVEC.fillPoint(ds, proj, obj, obj.getConstructionRelations(), obj.getSemanticRelations());
                    break;
                }
                case LINE: {
                    p2 = EdigeoFileVEC.fillLine(ds, proj, obj, obj.getConstructionRelations(), obj.getSemanticRelations());
                    break;
                }
                case AREA: {
                    p2 = EdigeoFileVEC.fillArea(ds, proj, obj, obj.getConstructionRelations(), obj.getSemanticRelations());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(obj.toString());
                }
            }
            if (p2 == null) continue;
            for (Pair<Predicate<ObjectBlock>, BiConsumer<ObjectBlock, OsmPrimitive>> e : postProcessors) {
                if (!((Predicate)e.a).test(obj)) continue;
                ((BiConsumer)e.b).accept(obj, p2);
            }
            if (!p2.isTagged()) continue;
            p2.put("source", CadastrePlugin.source);
        }
        return this;
    }

    private static <T extends OsmPrimitive> T addPrimitiveAndTags(DataSet ds, ObjectBlock obj, T osm) {
        if (osm != null) {
            for (int i = 0; i < obj.nAttributes; ++i) {
                String key = ((EdigeoFileSCD.McdAttributeDef)obj.attributeDefs.get((int)i)).identifier;
                if (key.startsWith("ID_S_ATT_")) continue;
                osm.put(key, (String)obj.attributeValues.get(i));
            }
            if (osm.getDataSet() == null) {
                ds.addPrimitive(osm);
            }
        }
        return osm;
    }

    private static <T extends VecBlock<?>> List<T> extract(Class<T> klass, List<RelationBlock> constructionRelations, EdigeoFileSCD.McdConstructionRelationDef.RelationKind kind) {
        ArrayList list = new ArrayList();
        for (RelationBlock rel : constructionRelations) {
            assert (rel.scdRef instanceof EdigeoFileSCD.McdConstructionRelationDef) : rel;
            if (!(rel.scdRef instanceof EdigeoFileSCD.McdConstructionRelationDef)) continue;
            EdigeoFileSCD.McdConstructionRelationDef crd = (EdigeoFileSCD.McdConstructionRelationDef)rel.scdRef;
            if (crd.kind != kind) continue;
            assert (crd.nAttributes == 0);
            for (VecBlock<?> e : rel.elements) {
                if (!klass.isInstance(e)) continue;
                list.add(e);
            }
        }
        return list;
    }

    private static Node fillPoint(DataSet ds, Projection proj, ObjectBlock obj, List<RelationBlock> constructionRelations, List<RelationBlock> semanticRelations) {
        assert (constructionRelations.size() == 1) : constructionRelations;
        List<NodeBlock> blocks = EdigeoFileVEC.extract(NodeBlock.class, constructionRelations, EdigeoFileSCD.McdConstructionRelationDef.RelationKind.IS_MADE_OF);
        assert (blocks.size() == 1) : blocks;
        NodeBlock nb = blocks.get(0);
        assert (nb.nAttributes == 0);
        LatLon ll = proj.eastNorth2latlon(nb.getCoordinate());
        List nodes = ds.searchNodes(EdigeoFileVEC.around(ll));
        assert (nodes.size() <= 1);
        Node n = nodes.isEmpty() ? new Node(ll) : (Node)nodes.get(0);
        return EdigeoFileVEC.addPrimitiveAndTags(ds, obj, n);
    }

    private static Way fillLine(DataSet ds, Projection proj, ObjectBlock obj, List<RelationBlock> constructionRelations, List<RelationBlock> semanticRelations) {
        assert (constructionRelations.size() >= 1) : constructionRelations;
        List<ArcBlock> arcs = EdigeoFileVEC.extract(ArcBlock.class, constructionRelations, EdigeoFileSCD.McdConstructionRelationDef.RelationKind.IS_MADE_OF_ARC);
        double EPSILON = 0.01;
        assert (arcs.size() >= 1);
        if (arcs.size() > 1) {
            List newArcs = arcs.stream().filter(a -> arcs.stream().noneMatch(b -> b.points.get(0).equalsEpsilon(a.points.get(a.nPoints - 1), 0.01))).collect(Collectors.toList());
            if (newArcs.size() != 1) {
                Logging.warn((String)("Unable to process geometry of: " + obj));
                return null;
            }
            while (newArcs.size() < arcs.size()) {
                ArcBlock ab = (ArcBlock)newArcs.get(newArcs.size() - 1);
                EastNorth en = ab.points.get(ab.nPoints - 1);
                Stream<ArcBlock> stream = arcs.stream().filter(a -> a.points.get(0).equalsEpsilon(en, 0.01));
                assert (stream.count() == 1L);
                newArcs.add(stream.findAny().get());
            }
            assert (newArcs.size() == arcs.size());
            arcs.clear();
            arcs.addAll(newArcs);
        }
        Way w = new Way();
        w.addNode(EdigeoFileVEC.getNodeAt(ds, proj, arcs.get((int)0).points.get(0)));
        for (ArcBlock ab : arcs) {
            assert (ab.nAttributes == 0) : ab;
            assert (ab.nQualities == 0) : ab;
            for (int i = 1; i < ab.nPoints; ++i) {
                w.addNode(EdigeoFileVEC.getNodeAt(ds, proj, ab.points.get(i)));
            }
        }
        assert (w.getNodesCount() >= 2);
        return EdigeoFileVEC.addPrimitiveAndTags(ds, obj, w);
    }

    private static OsmPrimitive fillArea(DataSet ds, Projection proj, ObjectBlock obj, List<RelationBlock> constructionRelations, List<RelationBlock> semanticRelations) {
        assert (constructionRelations.size() >= 1) : constructionRelations;
        List<FaceBlock> faces = EdigeoFileVEC.extract(FaceBlock.class, constructionRelations, EdigeoFileSCD.McdConstructionRelationDef.RelationKind.IS_MADE_OF);
        assert (faces.size() >= 1);
        if (faces.size() == 1) {
            return EdigeoFileVEC.addPrimitiveAndTags(ds, obj, EdigeoFileVEC.faceToOsmPrimitive(ds, proj, faces.get(0)));
        }
        Relation r = new Relation();
        r.put("type", "multipolygon");
        for (FaceBlock face : faces) {
            r.addMember(new RelationMember("outer", EdigeoFileVEC.faceToOsmPrimitive(ds, proj, face)));
        }
        return EdigeoFileVEC.addPrimitiveAndTags(ds, obj, r);
    }

    private static OsmPrimitive faceToOsmPrimitive(DataSet ds, Projection proj, FaceBlock face) {
        ArrayList<ArcBlock> allArcs = new ArrayList<ArcBlock>();
        allArcs.addAll(EdigeoFileVEC.extract(ArcBlock.class, face.getConstructionRelations(), EdigeoFileSCD.McdConstructionRelationDef.RelationKind.HAS_FOR_LEFT_FACE));
        allArcs.addAll(EdigeoFileVEC.extract(ArcBlock.class, face.getConstructionRelations(), EdigeoFileSCD.McdConstructionRelationDef.RelationKind.HAS_FOR_RIGHT_FACE));
        assert (allArcs.size() >= 1);
        if (allArcs.size() == 1) {
            ArcBlock ab2 = (ArcBlock)allArcs.get(0);
            assert (ab2.isClosed());
            return EdigeoFileVEC.arcToWay(ds, proj, ab2);
        }
        List<Way> ways = allArcs.stream().map(ab -> EdigeoFileVEC.arcToWay(ds, proj, ab)).filter(w -> w != null).collect(Collectors.toList());
        Pair cmd = CreateMultipolygonAction.createMultipolygonCommand(ways, null);
        if (cmd != null) {
            ((SequenceCommand)cmd.a).executeCommand();
            return (OsmPrimitive)cmd.b;
        }
        ways.forEach(w -> ds.removePrimitive(w.getPrimitiveId()));
        return null;
    }

    private static Way arcToWay(DataSet ds, Projection proj, ArcBlock ab) {
        Way way = new Way();
        for (int i = 0; i < ab.nPoints; ++i) {
            Node n = EdigeoFileVEC.getNodeAt(ds, proj, ab.points.get(i));
            if (i != 0 && n.equals((Object)way.lastNode())) continue;
            way.addNode(n);
        }
        if (way.getNodesCount() < 2) {
            return null;
        }
        List existingWays = ds.searchWays(way.getBBox()).stream().filter(w -> w.hasEqualSemanticAttributes((OsmPrimitive)way)).collect(Collectors.toList());
        if (existingWays.isEmpty()) {
            ds.addPrimitive((OsmPrimitive)way);
            return way;
        }
        return (Way)existingWays.get(0);
    }

    public final List<NodeBlock> getNodes() {
        return Collections.unmodifiableList(this.blocks.getInstances(NodeBlock.class));
    }

    public final List<ArcBlock> getArcs() {
        return Collections.unmodifiableList(this.blocks.getInstances(ArcBlock.class));
    }

    public final List<FaceBlock> getFaces() {
        return Collections.unmodifiableList(this.blocks.getInstances(FaceBlock.class));
    }

    public final List<ObjectBlock> getObjects() {
        return Collections.unmodifiableList(this.blocks.getInstances(ObjectBlock.class));
    }

    public final List<RelationBlock> getRelations() {
        return Collections.unmodifiableList(this.blocks.getInstances(RelationBlock.class));
    }

    public static class RelationBlock
    extends VecBlock<EdigeoFileSCD.McdRelationDef> {
        int nElements;
        final List<List<String>> lElements = new ArrayList<List<String>>();
        final Map<List<String>, Composition> mCompositions = new HashMap<List<String>, Composition>();
        final List<VecBlock<?>> elements = new ArrayList();
        final Map<VecBlock<?>, Composition> compositions = new HashMap();

        RelationBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type, EdigeoFileSCD.McdRelationDef.class);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "FTC": {
                    this.nElements = this.safeGetInt(r);
                    break;
                }
                case "FTP": {
                    this.lElements.add(r.values);
                    break;
                }
                case "SNS": {
                    this.mCompositions.put(this.lElements.get(this.lElements.size() - 1), Composition.of(this.safeGetChar(r)));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && this.nElements >= 2 && RelationBlock.areSameSize(this.nElements, this.elements) && this.compositions.size() <= this.nElements;
        }

        @Override
        final void resolvePhase1() {
            super.resolvePhase1();
            for (List<String> values : this.lElements) {
                VecBlock b = this.lot.vec.stream().filter(v -> v.subsetId.equals(values.get(1))).findAny().orElseThrow(() -> new IllegalArgumentException(values.toString())).find(values, VecBlock.class);
                b.addRelation(this);
                this.elements.add(b);
                this.compositions.put(b, this.mCompositions.get(values));
            }
            this.lElements.clear();
            this.mCompositions.clear();
        }

        public String toString() {
            return "RelationBlock [identifier=" + this.identifier + ']';
        }

        static enum Composition {
            PLUS('P'),
            MINUS('M');

            final char code;

            private Composition(char code) {
                this.code = code;
            }

            public static Composition of(char code) {
                for (Composition s : Composition.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Character.toString(code));
            }
        }
    }

    public static class ObjectBlock
    extends BoundedBlock<EdigeoFileSCD.McdObjectDef> {
        EastNorth refPoint;

        ObjectBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type, EdigeoFileSCD.McdObjectDef.class);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "REF": {
                    this.refPoint = this.safeGetEastNorth(r);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        public String toString() {
            return "ObjectBlock [identifier=" + this.identifier + ", attributeDefs=" + this.attributeDefs + ", attributeValues=" + this.attributeValues + ']';
        }
    }

    public static class FaceBlock
    extends BoundedBlock<EdigeoFileSCD.McdPrimitiveDef> {
        FaceBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type, EdigeoFileSCD.McdPrimitiveDef.class);
        }

        public String toString() {
            return "FaceBlock [identifier=" + this.identifier + ']';
        }
    }

    public static class ArcBlock
    extends BoundedBlock<EdigeoFileSCD.McdPrimitiveDef> {
        ArcType arcType;
        int nPoints;
        final List<EastNorth> points = new ArrayList<EastNorth>();

        ArcBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type, EdigeoFileSCD.McdPrimitiveDef.class);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "TYP": {
                    this.arcType = ArcType.of(this.safeGetInt(r));
                    break;
                }
                case "PTC": {
                    this.nPoints = this.safeGetInt(r);
                    break;
                }
                case "COR": {
                    this.points.add(this.safeGetEastNorth(r));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && ArcBlock.areNotNull(new Object[]{this.arcType}) && this.checkNumberOfPoints() && ArcBlock.areSameSize(this.nPoints, this.points);
        }

        public String toString() {
            return "ArcBlock [identifier=" + this.identifier + ']';
        }

        private boolean checkNumberOfPoints() {
            switch (this.arcType) {
                case LINE: {
                    return this.nPoints >= 2;
                }
                case CIRCLE_ARC: {
                    return this.nPoints == 3;
                }
                case CURVE: {
                    return this.nPoints >= 3;
                }
            }
            throw new IllegalStateException(this.arcType.toString());
        }

        boolean isClosed() {
            return this.nPoints >= 4 && this.points.get(0).equals((Object)this.points.get(this.nPoints - 1));
        }

        static enum ArcType {
            LINE(1),
            CIRCLE_ARC(2),
            CURVE(3);

            int code;

            private ArcType(int code) {
                this.code = code;
            }

            public static ArcType of(int code) {
                for (ArcType s : ArcType.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }
    }

    public static class NodeBlock
    extends VecBlock<EdigeoFileSCD.McdPrimitiveDef> {
        NodeType nodeType;
        EastNorth coordinate;

        NodeBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type, EdigeoFileSCD.McdPrimitiveDef.class);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "TYP": {
                    this.nodeType = NodeType.of(this.safeGetInt(r));
                    break;
                }
                case "COR": {
                    this.coordinate = this.safeGetEastNorth(r);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        public String toString() {
            return "NodeBlock [identifier=" + this.identifier + ']';
        }

        public final EdigeoFileSCD.McdPrimitiveDef getScdRef() {
            return (EdigeoFileSCD.McdPrimitiveDef)this.scdRef;
        }

        public final NodeType getNodeType() {
            return this.nodeType;
        }

        public final EastNorth getCoordinate() {
            return this.coordinate;
        }

        public final int getNumberOfQualityIndicators() {
            return this.nQualities;
        }

        static enum NodeType {
            INITIAL_OR_FINAL(1),
            ISOLATED(2);

            int code;

            private NodeType(int code) {
                this.code = code;
            }

            public static NodeType of(int code) {
                for (NodeType s : NodeType.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }
    }

    static abstract class BoundedBlock<T extends EdigeoFileSCD.ScdBlock>
    extends VecBlock<T> {
        EastNorth minCoordinate;
        EastNorth maxCoordinate;

        BoundedBlock(EdigeoFileTHF.Lot lot, String type, Class<T> klass) {
            super(lot, type, klass);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "CM1": {
                    this.minCoordinate = this.safeGetEastNorth(r);
                    break;
                }
                case "CM2": {
                    this.maxCoordinate = this.safeGetEastNorth(r);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }
    }

    static abstract class VecBlock<T extends EdigeoFileSCD.ScdBlock>
    extends EdigeoFileTHF.ChildBlock {
        private final Class<T> klass;
        private final List<RelationBlock> parentRelations = new ArrayList<RelationBlock>();
        T scdRef;
        int nAttributes;
        final List<EdigeoFileSCD.McdAttributeDef> attributeDefs = new ArrayList<EdigeoFileSCD.McdAttributeDef>();
        EdigeoCharset charset;
        final List<EdigeoRecord> lAttributeValues = new ArrayList<EdigeoRecord>();
        int nQualities;
        final List<String> qualityIndics = new ArrayList<String>();
        final List<String> attributeValues = new ArrayList<String>();

        VecBlock(EdigeoFileTHF.Lot lot, String type, Class<T> klass) {
            super(lot, type);
            this.klass = Objects.requireNonNull(klass, "klass");
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "SCP": {
                    this.scdRef = (EdigeoFileSCD.ScdBlock)this.lot.scd.find(r.values, this.klass);
                    break;
                }
                case "ATC": {
                    this.nAttributes = this.safeGetInt(r);
                    break;
                }
                case "ATP": {
                    this.attributeDefs.add(this.lot.scd.find(r.values, EdigeoFileSCD.McdAttributeDef.class));
                    break;
                }
                case "TEX": {
                    this.safeGet(r, (String s) -> {
                        this.charset = EdigeoCharset.of(s);
                    });
                    break;
                }
                case "ATV": {
                    this.lAttributeValues.add(r);
                    break;
                }
                case "QAC": {
                    this.nQualities = this.safeGetInt(r);
                    break;
                }
                case "QAP": {
                    this.safeGet(r, this.qualityIndics);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        void resolvePhase1() {
            super.resolvePhase1();
            for (EdigeoRecord r : this.lAttributeValues) {
                this.attributeValues.add(r.values.get(0));
            }
        }

        @Override
        void resolvePhase2() {
            super.resolvePhase2();
            for (int i = 0; i < this.nAttributes; ++i) {
                EdigeoRecord r = this.lAttributeValues.get(i);
                if (r.nature != EdigeoRecord.Nature.COMPOSED) continue;
                assert (!this.parentRelations.isEmpty());
                EdigeoFileSCD.McdAttributeDef def = this.lot.scd.find(r.values, EdigeoFileSCD.McdAttributeDef.class);
                List relations = this.getSemanticRelations().stream().filter(rel -> rel.elements.stream().anyMatch(e -> e.attributeDefs.contains(def))).collect(Collectors.toList());
                assert (relations.size() == 1);
                List elements = ((RelationBlock)relations.get((int)0)).elements.stream().filter(e -> e.attributeDefs.contains(def)).collect(Collectors.toList());
                assert (elements.size() == 1);
                VecBlock e2 = (VecBlock)elements.get(0);
                this.attributeValues.set(i, e2.attributeValues.get(e2.attributeDefs.indexOf(def)));
                this.attributeDefs.set(i, def);
            }
            this.lAttributeValues.clear();
        }

        @Override
        boolean isValid() {
            return super.isValid() && VecBlock.areNotNull(this.scdRef) && VecBlock.areSameSize(this.nAttributes, this.attributeDefs, this.attributeValues) && VecBlock.areSameSize(this.nQualities, this.qualityIndics);
        }

        final boolean addRelation(RelationBlock relationBlock) {
            return this.parentRelations.add(Objects.requireNonNull(relationBlock, "relationBlock"));
        }

        public final List<RelationBlock> getConstructionRelations() {
            return this.parentRelations.stream().filter(r -> r.scdRef instanceof EdigeoFileSCD.McdConstructionRelationDef).collect(Collectors.toList());
        }

        public final List<RelationBlock> getSemanticRelations() {
            return this.parentRelations.stream().filter(r -> r.scdRef instanceof EdigeoFileSCD.McdSemanticRelationDef).collect(Collectors.toList());
        }

        public final int getNumberOfAttributes() {
            return this.nAttributes;
        }

        public final List<EdigeoFileSCD.McdAttributeDef> getAttributeDefinitions() {
            return Collections.unmodifiableList(this.attributeDefs);
        }

        public final EdigeoFileSCD.McdAttributeDef getAttributeDefinition(int i) {
            return this.attributeDefs.get(i);
        }

        public final String getAttributeValue(int i) {
            return this.attributeValues.get(i);
        }

        public boolean hasScdIdentifier(String id) {
            return ((EdigeoFileSCD.ScdBlock)this.scdRef).identifier.equals(id);
        }
    }
}

