/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.elevation.ColorMap;
import org.openstreetmap.josm.plugins.elevation.ElevationMapMode;
import org.openstreetmap.josm.plugins.elevation.actions.AddElevationLayerAction;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileDialog;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileLayer;
import org.openstreetmap.josm.tools.I18n;

public class ElevationProfilePlugin
extends Plugin {
    private static ElevationProfileLayer currentLayer;

    public ElevationProfilePlugin(PluginInformation info) {
        super(info);
        this.createColorMaps();
        MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)new AddElevationLayerAction(), (boolean)false, (Integer)0);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (newFrame != null) {
            ElevationMapMode eleMode = new ElevationMapMode("Elevation profile");
            newFrame.addMapMode(new IconToggleButton((Action)((Object)eleMode)));
            ElevationProfileDialog eleProfileDlg = new ElevationProfileDialog();
            eleProfileDlg.addModelListener(eleMode);
            eleProfileDlg.setProfileLayer(ElevationProfilePlugin.getCurrentLayer());
            newFrame.addToggleDialog((ToggleDialog)eleProfileDlg);
        }
    }

    public static ElevationProfileLayer getCurrentLayer() {
        if (currentLayer == null) {
            currentLayer = new ElevationProfileLayer(I18n.tr((String)"Elevation Profile", (Object[])new Object[0]));
            MainApplication.getLayerManager().addLayer((Layer)currentLayer);
        }
        return currentLayer;
    }

    private void createColorMaps() {
        ColorMap.create("Physical_US", new Color[]{new Color(18, 129, 242), new Color(113, 153, 89), new Color(117, 170, 101), new Color(149, 190, 113), new Color(178, 214, 117), new Color(202, 226, 149), new Color(222, 238, 161), new Color(242, 238, 161), new Color(238, 222, 153), new Color(242, 206, 133), new Color(234, 182, 129), new Color(218, 157, 121), new Color(194, 141, 125), new Color(214, 157, 145), new Color(226, 174, 165), new Color(222, 186, 182), new Color(238, 198, 210), new Color(255, 206, 226), new Color(250, 218, 234), new Color(255, 222, 230), new Color(255, 230, 242), new Color(255, 242, 255)}, new int[]{-3000, 0, 150, 300, 450, 600, 750, 900, 1050, 1200, 1350, 1500, 1650, 1800, 1950, 2100, 2250, 2400, 2550, 2700, 2750, 3000});
    }
}

