/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;

class HSLColor {
    double hue;
    double saturation;
    double lightness;
    double alpha;

    public HSLColor(double hue, double saturation, double lightness) {
        this(hue, saturation, lightness, 1.0);
    }

    public HSLColor(double hue, double saturation, double lightness, double alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.lightness = lightness;
        this.alpha = alpha;
    }

    public HSLColor(Color color) {
        double r = (double)color.getRed() / 255.0;
        double g = (double)color.getGreen() / 255.0;
        double b = (double)color.getBlue() / 255.0;
        this.alpha = (double)color.getAlpha() / 255.0;
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        this.lightness = (max + min) / 2.0;
        this.saturation = 0.0;
        this.saturation = max == min ? 0.0 : (this.lightness <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        this.hue = 0.0;
        if (max == min) {
            this.hue = 0.0;
        } else if (max == r) {
            this.hue = (60.0 * (g - b) / (max - min) + 360.0) % 360.0;
        } else if (max == g) {
            this.hue = 60.0 * (b - r) / (max - min) + 120.0;
        } else if (max == b) {
            this.hue = 60.0 * (r - g) / (max - min) + 240.0;
        }
    }

    public void setHue(double hue) {
        this.hue = hue;
    }

    public void setSaturation(double saturation) {
        this.saturation = saturation < 0.0 ? 0.0 : (saturation > 1.0 ? 1.0 : saturation);
    }

    public void setLightness(double lightness) {
        this.lightness = lightness;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getHue() {
        return this.hue;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public double getLightness() {
        return this.lightness;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public Color toRGB() {
        double q = 0.0;
        q = this.lightness < 0.5 ? this.lightness * (1.0 + this.saturation) : this.lightness + this.saturation - this.saturation * this.lightness;
        double p = 2.0 * this.lightness - q;
        double r = Math.max(0.0, this.hueToRGB(p, q, this.hue / 360.0 + 0.3333333432674408));
        double g = Math.max(0.0, this.hueToRGB(p, q, this.hue / 360.0));
        double b = Math.max(0.0, this.hueToRGB(p, q, this.hue / 360.0 - 0.3333333432674408));
        r = Math.min(r, 1.0);
        g = Math.min(g, 1.0);
        b = Math.min(b, 1.0);
        return new Color((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0), (int)Math.round(this.alpha * 255.0));
    }

    private double hueToRGB(double p, double q, double h) {
        if (h < 0.0) {
            h += 1.0;
        } else if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return p + (q - p) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return q;
        }
        if (3.0 * h < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666865348816 - h);
        }
        return p;
    }

    public String toString() {
        return "HSLColor [" + this.hue + "," + this.saturation + "," + this.lightness + "," + this.alpha + "]";
    }
}

