/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.binding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;

class LoggingProxy
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(LoggingProxy.class);
    private final LibVlc target;

    LoggingProxy(LibVlc target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            this.before(method, args);
            result = method.invoke((Object)this.target, args);
            this.after(method, result);
        }
        catch (InvocationTargetException e) {
            this.exception(method, e.getCause());
            throw e;
        }
        return result;
    }

    private void before(Method method, Object[] args) {
        this.logger.trace("call {}: {}", (Object)method.getName(), (Object)Arrays.toString(args));
    }

    private void after(Method method, Object result) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            this.logger.trace("return {}: {}", (Object)method.getName(), result);
        } else {
            this.logger.trace("return {}: void", (Object)method.getName());
        }
    }

    private void exception(Method method, Throwable t) {
        this.logger.trace("exception {}: {}", (Object)method.getName(), (Object)t);
    }
}

