/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping.video;

import com.sun.jna.NativeLibrary;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.videomapping.video.Video;
import org.openstreetmap.josm.plugins.videomapping.video.VideoObserversEvents;
import org.openstreetmap.josm.plugins.videomapping.video.VideosObserver;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.player.DeinterlaceMode;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.DefaultFullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.runtime.windows.WindowsRuntimeUtil;

public class VideoEngine
implements MediaPlayerEventListener {
    private FullScreenStrategy fullScreenStrategy;
    public MediaPlayerFactory mediaPlayerFactory;
    private List<Video> videos;
    private List<VideosObserver> observers;
    private final String[] libvlcArgs = new String[]{""};
    private final String[] standardMediaOptions = new String[]{""};
    private static final String[] deinterlacers = new String[]{"bob", "linear"};
    private boolean singleVideoMode;
    private Video lastAddedVideo;

    public static void setupPlayer() {
        String vlcInstallDir = null;
        if (RuntimeUtil.isWindows()) {
            vlcInstallDir = WindowsRuntimeUtil.getVlcInstallDir();
            String arch = System.getProperty("os.arch");
            if (vlcInstallDir == null && arch.equals("amd64")) {
                try {
                    vlcInstallDir = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\VideoLAN\\VLC".replaceFirst("\\\\", "\\\\Wow6432Node\\\\"), (String)"InstallDir");
                }
                catch (RuntimeException e) {
                    Logging.error((Throwable)e);
                }
            }
        } else if (RuntimeUtil.isMac() || RuntimeUtil.isNix()) {
            // empty if block
        }
        if (vlcInstallDir != null) {
            Logging.info((String)("videomapping: found VLC install dir: " + vlcInstallDir));
            NativeLibrary.addSearchPath((String)"libvlc", (String)vlcInstallDir);
        } else {
            Logging.error((String)"videomapping: unable to locate VLC install dir");
        }
    }

    public VideoEngine(Window parent) {
        System.setProperty("logj4.configuration", "file:log4j.xml");
        this.videos = new LinkedList<Video>();
        this.observers = new LinkedList<VideosObserver>();
        try {
            this.mediaPlayerFactory = new MediaPlayerFactory(this.libvlcArgs);
            this.fullScreenStrategy = new DefaultFullScreenStrategy(parent);
        }
        catch (NoClassDefFoundError e) {
            Logging.error((String)I18n.tr((String)"Unable to find JNA Java library!", (Object[])new Object[0]));
        }
        catch (UnsatisfiedLinkError e) {
            Logging.error((String)I18n.tr((String)"Unable to find native libvlc library!", (Object[])new Object[0]));
        }
        catch (Exception t) {
            Logging.error((Throwable)t);
        }
    }

    public void add(Video video) {
        try {
            EmbeddedMediaPlayer mp = this.mediaPlayerFactory.newEmbeddedMediaPlayer(this.fullScreenStrategy);
            video.player = mp;
            mp.setStandardMediaOptions(this.standardMediaOptions);
            this.videos.add(video);
            this.lastAddedVideo = video;
            mp.setVideoSurface(video.videoSurface);
            mp.addMediaPlayerEventListener(this);
            String mediaPath = video.filename.getAbsoluteFile().toString();
            mp.playMedia(mediaPath, new String[0]);
        }
        catch (NoClassDefFoundError e) {
            Logging.error((String)I18n.tr((String)"Unable to find JNA Java library!", (Object[])new Object[0]));
        }
        catch (UnsatisfiedLinkError e) {
            Logging.error((String)I18n.tr((String)"Unable to find native libvlc library!", (Object[])new Object[0]));
        }
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public void play() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.play();
        } else {
            for (Video video : this.videos) {
                video.player.play();
            }
        }
    }

    public void pause() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.pause();
        } else {
            for (Video video : this.videos) {
                video.player.pause();
            }
        }
    }

    public void pauseAll() {
        for (Video video : this.videos) {
            if (!video.player.isPlaying()) continue;
            video.player.pause();
        }
    }

    public void jumpFor(long ms) {
        if (this.singleVideoMode) {
            long start = this.lastAddedVideo.player.getTime();
            this.lastAddedVideo.player.setTime(start + ms);
        } else {
            for (Video video : this.videos) {
                long start = video.player.getTime();
                video.player.setTime(start + ms);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public void jumpTo(long msVideo) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setTime(msVideo);
        } else {
            for (Video video : this.videos) {
                video.player.setTime(msVideo);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public long getVideoTime() {
        return this.videos.get((int)0).player.getTime();
    }

    public void jumpToPosition(int percent) {
        float position = (float)percent / 100.0f;
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setPosition(position);
        } else {
            for (Video video : this.videos) {
                video.player.setPosition(position);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public int getPosition() {
        return (int)(this.videos.get((int)0).player.getPosition() * 100.0f);
    }

    public void setSpeed(int percent) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setRate((float)percent / 100.0f);
        }
        for (Video video : this.videos) {
            video.player.setRate((float)percent / 100.0f);
        }
        this.notifyObservers(VideoObserversEvents.speeding);
    }

    public int getSpeed() {
        return (int)(this.videos.get((int)0).player.getRate() * 100.0f);
    }

    public boolean hasSubtitles() {
        for (Video video : this.videos) {
            if (video.player.getSpuCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setSubtitles(boolean enabled) {
        if (enabled) {
            for (Video video : this.videos) {
                video.player.setSpu(0);
            }
        } else {
            for (Video video : this.videos) {
                video.player.setSpu(-1);
            }
        }
    }

    public void setDeinterlacer(DeinterlaceMode deinterlacer) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setDeinterlace(deinterlacer);
        } else {
            for (Video video : this.videos) {
                video.player.setDeinterlace(deinterlacer);
            }
        }
    }

    public static String[] getDeinterlacers() {
        return deinterlacers;
    }

    public void mute() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.mute();
        }
        for (Video video : this.videos) {
            video.player.mute();
        }
    }

    public void unload() {
        for (Video video : this.videos) {
            video.player.stop();
            video.player.release();
            video.player = null;
            video.videoSurface = null;
            video.canvas = null;
        }
        this.mediaPlayerFactory.release();
    }

    public void addObserver(VideosObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObservers(VideoObserversEvents event) {
        for (VideosObserver observer : this.observers) {
            observer.update(event);
        }
    }

    @Override
    public void backward(MediaPlayer arg0) {
    }

    @Override
    public void error(MediaPlayer arg0) {
    }

    @Override
    public void finished(MediaPlayer arg0) {
    }

    @Override
    public void forward(MediaPlayer arg0) {
    }

    @Override
    public void lengthChanged(MediaPlayer arg0, long arg1) {
    }

    @Override
    public void opening(MediaPlayer arg0) {
    }

    @Override
    public void pausableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void paused(MediaPlayer arg0) {
    }

    @Override
    public void playing(MediaPlayer arg0) {
    }

    @Override
    public void positionChanged(MediaPlayer arg0, float arg1) {
    }

    @Override
    public void seekableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void snapshotTaken(MediaPlayer arg0, String arg1) {
    }

    @Override
    public void stopped(MediaPlayer arg0) {
    }

    @Override
    public void timeChanged(MediaPlayer arg0, long arg1) {
    }

    @Override
    public void titleChanged(MediaPlayer arg0, int arg1) {
    }

    public boolean isNoVideoPlaying() {
        for (Video video : this.videos) {
            if (!video.player.isPlaying()) continue;
            return false;
        }
        return true;
    }

    public void enableSingleVideoMode(boolean enabled) {
        this.singleVideoMode = true;
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t media, String mrl) {
    }

    @Override
    public void buffering(MediaPlayer mediaPlayer, float newCache) {
    }

    @Override
    public void videoOutput(MediaPlayer mediaPlayer, int newCount) {
    }

    @Override
    public void mediaMetaChanged(MediaPlayer mediaPlayer, int metaType) {
    }

    @Override
    public void mediaSubItemAdded(MediaPlayer mediaPlayer, libvlc_media_t subItem) {
    }

    @Override
    public void mediaDurationChanged(MediaPlayer mediaPlayer, long newDuration) {
    }

    @Override
    public void mediaParsedChanged(MediaPlayer mediaPlayer, int newStatus) {
    }

    @Override
    public void mediaFreed(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaStateChanged(MediaPlayer mediaPlayer, int newState) {
    }

    @Override
    public void newMedia(MediaPlayer mediaPlayer) {
    }

    @Override
    public void subItemPlayed(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void subItemFinished(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void endOfSubItems(MediaPlayer mediaPlayer) {
    }

    @Override
    public void scrambledChanged(MediaPlayer mediaPlayer, int newScrambled) {
    }

    @Override
    public void elementaryStreamAdded(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void elementaryStreamDeleted(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void elementaryStreamSelected(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void corked(MediaPlayer mediaPlayer, boolean corked) {
    }

    @Override
    public void muted(MediaPlayer mediaPlayer, boolean muted) {
    }

    @Override
    public void volumeChanged(MediaPlayer mediaPlayer, float volume) {
    }

    @Override
    public void audioDeviceChanged(MediaPlayer mediaPlayer, String audioDevice) {
    }

    @Override
    public void chapterChanged(MediaPlayer mediaPlayer, int newChapter) {
    }

    @Override
    public void mediaSubItemTreeAdded(MediaPlayer mediaPlayer, libvlc_media_t item) {
    }
}

