/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.CylindricalProjection;

public class CentralCylindricalProjection
extends CylindricalProjection {
    private double ap;
    private static final double EPS10 = 1.0E-10;

    public CentralCylindricalProjection() {
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) <= 1.0E-10) {
            throw new ProjectionException("F");
        }
        out.x = lplam;
        out.y = Math.tan(lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = Math.atan(xyy);
        out.x = xyx;
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Central Cylindrical";
    }
}

