/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.NameFinder;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class WikosmDownloadReader
extends BoundingBoxDownloader {
    public static final StringProperty WIKOSM_SERVER = new StringProperty("download.wikosm.server", "http://88.99.164.208/bigdata/namespace/wdq/sparql");
    public static final ListProperty WIKOSM_SERVER_HISTORY = new ListProperty("download.wikosm.servers", Arrays.asList("http://88.99.164.208/bigdata/namespace/wdq/sparql"));
    private static final String DATA_PREFIX = "?query=";
    private final String wikosmServer;
    private final String wikosmQuery;
    private final boolean asNewLayer;
    private final boolean downloadReferrers;
    private final boolean downloadFull;

    public WikosmDownloadReader(Bounds downloadArea, String wikosmServer, String wikosmQuery, boolean asNewLayer, boolean downloadReferrers, boolean downloadFull) {
        super(downloadArea);
        this.setDoAuthenticate(false);
        this.wikosmServer = wikosmServer;
        this.wikosmQuery = wikosmQuery.trim();
        this.asNewLayer = asNewLayer;
        this.downloadReferrers = downloadReferrers;
        this.downloadFull = downloadFull;
    }

    protected String getBaseUrl() {
        return this.wikosmServer;
    }

    protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
        String query = this.wikosmQuery.replace("{{boxParams}}", WikosmDownloadReader.boxParams(lon1, lat1, lon2, lat2)).replace("{{center}}", WikosmDownloadReader.center(lon1, lat1, lon2, lat2));
        return DATA_PREFIX + Utils.encodeUrl((String)query);
    }

    public static String boxParams(double lon1, double lat1, double lon2, double lat2) {
        return "\nbd:serviceParam wikibase:cornerWest " + WikosmDownloadReader.point(lon1, lat1) + ".\nbd:serviceParam wikibase:cornerEast " + WikosmDownloadReader.point(lon2, lat2) + ".\n";
    }

    public static String center(double lon1, double lat1, double lon2, double lat2) {
        LatLon c = new BBox(lon1, lat1, lon2, lat2).getCenter();
        return WikosmDownloadReader.point(c.lon(), c.lat());
    }

    public static String point(double lon, double lat) {
        return "\"Point(" + lon + " " + lat + ")\"^^geo:wktLiteral";
    }

    static String date(String humanDuration, LocalDateTime from) {
        String duration = humanDuration.toLowerCase(Locale.ENGLISH).replace(" ", "").replaceAll("years?", "Y").replaceAll("months?", "X").replaceAll("weeks?", "W").replaceAll("days?", "D").replaceAll("hours?", "H").replaceAll("minutes?", "M").replaceAll("seconds?", "S");
        Matcher matcher = Pattern.compile("((?:[0-9]+Y)?(?:[0-9]+X)?(?:[0-9]+W)?)((?:[0-9]+D)?)((?:[0-9]+H)?(?:[0-9]+M)?(?:[0-9]+(?:[.,][0-9]{0,9})?S)?)?").matcher(duration);
        boolean javaPer = false;
        boolean javaDur = false;
        if (matcher.matches()) {
            javaPer = matcher.group(1) != null && !matcher.group(1).isEmpty();
            javaDur = matcher.group(3) != null && !matcher.group(3).isEmpty();
            duration = 'P' + matcher.group(1).replace('X', 'M') + matcher.group(2);
            if (javaDur) {
                duration = duration + 'T' + matcher.group(3);
            }
        }
        Period p = null;
        Duration d = null;
        int idx = duration.indexOf(84);
        if (javaPer) {
            p = Period.parse(javaDur ? duration.substring(0, idx) : duration);
        }
        if (javaDur) {
            d = Duration.parse(javaPer ? 'P' + duration.substring(idx, duration.length()) : duration);
        } else if (!javaPer) {
            d = Duration.parse(duration);
        }
        LocalDateTime dt = from;
        if (p != null) {
            dt = dt.minus(p);
        }
        if (d != null) {
            dt = dt.minus(d);
        }
        return dt.toInstant(ZoneOffset.UTC).toString();
    }

    private static NameFinder.SearchResult searchName(String area) throws IOException {
        return (NameFinder.SearchResult)NameFinder.queryNominatim((String)area).stream().filter(x -> !OsmPrimitiveType.NODE.equals((Object)x.getOsmId().getType())).iterator().next();
    }

    static String geocodeArea(String area) throws IOException {
        EnumMap<OsmPrimitiveType, Long> idOffset = new EnumMap<OsmPrimitiveType, Long>(OsmPrimitiveType.class);
        idOffset.put(OsmPrimitiveType.NODE, 0L);
        idOffset.put(OsmPrimitiveType.WAY, 2400000000L);
        idOffset.put(OsmPrimitiveType.RELATION, 3600000000L);
        PrimitiveId osmId = WikosmDownloadReader.searchName(area).getOsmId();
        return String.format("area(%d)", osmId.getUniqueId() + (Long)idOffset.get(osmId.getType()));
    }

    static String geocodeBbox(String area) throws IOException {
        Bounds bounds = WikosmDownloadReader.searchName(area).getBounds();
        return bounds.getMinLat() + "," + bounds.getMinLon() + "," + bounds.getMaxLat() + "," + bounds.getMaxLon();
    }

    static String geocodeCoords(String area) throws IOException {
        NameFinder.SearchResult result = WikosmDownloadReader.searchName(area);
        return result.getLat() + "," + result.getLon();
    }

    static String geocodeId(String area) throws IOException {
        PrimitiveId osmId = WikosmDownloadReader.searchName(area).getOsmId();
        return String.format("%s(%d)", osmId.getType().getAPIName(), osmId.getUniqueId());
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition) throws OsmTransferException {
        return super.getInputStreamRaw(urlStr, progressMonitor, reason, uncompressAccordingToContentDisposition);
    }

    protected void adaptRequest(HttpClient request) {
        Matcher timeoutMatcher = Pattern.compile("#timeout:(\\d+)").matcher(this.wikosmQuery);
        int timeout = timeoutMatcher.find() ? (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(timeoutMatcher.group(1))) : (int)TimeUnit.MINUTES.toMillis(3L);
        request.setConnectTimeout(timeout);
        request.setReadTimeout(timeout);
        request.setAccept("application/sparql-results+json");
    }

    protected String getTaskName() {
        return I18n.tr((String)"Contacting Server...", (Object[])new Object[0]);
    }

    protected DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        try {
            List<PrimitiveId> ids = WikosmDownloadReader.getPrimitiveIds(source);
            DownloadPrimitiveAction.processItems((boolean)this.asNewLayer, ids, (boolean)this.downloadReferrers, (boolean)this.downloadFull);
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        return null;
    }

    static List<PrimitiveId> getPrimitiveIds(InputStream source) throws UnsupportedEncodingException {
        Pattern uriPattern = Pattern.compile("^https://www\\.openstreetmap\\.org/(node|way|relation)/(\\d+)");
        ArrayList<PrimitiveId> ids = new ArrayList<PrimitiveId>();
        JsonArray results = Json.createReader((Reader)new InputStreamReader(source, "UTF-8")).readObject().getJsonObject("results").getJsonArray("bindings");
        for (JsonObject row : results.getValuesAs(JsonObject.class)) {
            for (JsonValue column : row.values()) {
                Matcher matcher;
                JsonObject columnObj = (JsonObject)column;
                if (!columnObj.getString("type").equals("uri") || !(matcher = uriPattern.matcher(columnObj.getString("value"))).matches()) continue;
                ids.add((PrimitiveId)new SimplePrimitiveId(Long.parseLong(matcher.group(2)), OsmPrimitiveType.from((String)matcher.group(1))));
            }
        }
        return ids;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet ds = super.parseOsm(progressMonitor);
        if (ds != null && ds.getDataSources().isEmpty() && this.wikosmQuery.contains("{{boxParams}}")) {
            if (this.crosses180th) {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                DataSource src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
                bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
            } else {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                DataSource src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
            }
        }
        return ds;
    }
}

