/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.tools.date.DateUtils;

public class KmlReader
extends AbstractReader {
    public static final String KML_PLACEMARK = "Placemark";
    public static final String KML_NAME = "name";
    public static final String KML_COLOR = "color";
    public static final String KML_SIMPLE_DATA = "SimpleData";
    public static final String KML_LINE_STRING = "LineString";
    public static final String KML_POINT = "Point";
    public static final String KML_POLYGON = "Polygon";
    public static final String KML_OUTER_BOUND = "outerBoundaryIs";
    public static final String KML_INNER_BOUND = "innerBoundaryIs";
    public static final String KML_LINEAR_RING = "LinearRing";
    public static final String KML_COORDINATES = "coordinates";
    public static final String KML_WHEN = "when";
    public static final String KML_EXT_TRACK = "Track";
    public static final String KML_EXT_COORD = "coord";
    public static Pattern COLOR_PATTERN = Pattern.compile("\\p{XDigit}{8}");
    private XMLStreamReader parser;
    private Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();

    public KmlReader(XMLStreamReader parser) {
        this.parser = parser;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in);
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
        return new KmlReader(parser).parseDoc();
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    private DataSet parseDoc() throws XMLStreamException {
        DataSet ds = new DataSet();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.parser.getLocalName().equals(KML_PLACEMARK)) continue;
            this.parsePlaceMark(ds);
        }
        return ds;
    }

    private static boolean keyIsIgnored(String key) {
        for (ProjectionPatterns pp : OdConstants.PROJECTIONS) {
            if (!pp.getXPattern().matcher(key).matches() && !pp.getYPattern().matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private void parsePlaceMark(DataSet ds) throws XMLStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        long when = 0L;
        Way way = null;
        Node node = null;
        Relation relation = null;
        String role = "";
        HashMap<String, String> tags = new HashMap<String, String>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals(KML_COLOR)) {
                    String string = this.parser.getElementText();
                    if (!COLOR_PATTERN.matcher(string).matches()) continue;
                    tags.put(KML_COLOR, '#' + string.substring(6, 8) + string.substring(4, 6) + string.substring(2, 4));
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_NAME)) {
                    tags.put(KML_NAME, this.parser.getElementText());
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_SIMPLE_DATA)) {
                    String string = this.parser.getAttributeValue(null, KML_NAME);
                    if (KmlReader.keyIsIgnored(string)) continue;
                    tags.put(string, this.parser.getElementText());
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_POLYGON)) {
                    relation = new Relation();
                    ds.addPrimitive((OsmPrimitive)relation);
                    relation.put("type", "multipolygon");
                    list.add(relation);
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_OUTER_BOUND)) {
                    role = "outer";
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_INNER_BOUND)) {
                    role = "inner";
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_LINEAR_RING)) {
                    if (relation == null) continue;
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    relation.addMember(new RelationMember(role, (OsmPrimitive)way));
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_LINE_STRING) || this.parser.getLocalName().equals(KML_EXT_TRACK)) {
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    list.add(way);
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_COORDINATES)) {
                    String[] stringArray = this.parser.getElementText().trim().split("\\s");
                    for (int i = 0; i < stringArray.length; ++i) {
                        node = this.parseNode(ds, way, node, stringArray[i].split(","));
                    }
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_EXT_COORD)) {
                    if ((node = this.parseNode(ds, way, node, this.parser.getElementText().trim().split("\\s"))) == null || when <= 0L) continue;
                    node.setRawTimestamp((int)when);
                    continue;
                }
                if (!this.parser.getLocalName().equals(KML_WHEN)) continue;
                when = DateUtils.tsFromString((String)this.parser.getElementText().trim());
                continue;
            }
            if (event != 2) continue;
            if (this.parser.getLocalName().equals(KML_PLACEMARK)) break;
            if (!this.parser.getLocalName().equals(KML_POINT)) continue;
            list.add(node);
        }
        for (OsmPrimitive osmPrimitive : list) {
            for (String key : tags.keySet()) {
                osmPrimitive.put(key, (String)tags.get(key));
            }
        }
    }

    private Node parseNode(DataSet ds, Way way, Node node, String[] values) {
        if (values.length >= 2) {
            LatLon ll = new LatLon(Double.valueOf(values[1]).doubleValue(), Double.valueOf(values[0]).doubleValue()).getRoundedToOsmPrecision();
            node = this.nodes.get(ll);
            if (node == null) {
                node = new Node(ll);
                ds.addPrimitive((OsmPrimitive)node);
                this.nodes.put(ll, node);
                if (values.length > 2 && !values[2].equals("0")) {
                    node.put("ele", values[2]);
                }
            }
            if (way != null) {
                way.addNode(node);
            }
        }
        return node;
    }
}

