/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.FixedField;
import org.apache.poi.util.LittleEndian;

public class IntegerField
implements FixedField {
    private int _value;
    private final int _offset;

    public IntegerField(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset");
        }
        this._offset = n;
    }

    public IntegerField(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.readFromBytes(byArray);
    }

    public IntegerField(int n, int n2, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(n2, byArray);
    }

    public int get() {
        return this._value;
    }

    public void set(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = n;
        this.writeToBytes(byArray);
    }

    @Override
    public void readFromBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getInt(byArray, this._offset);
    }

    @Override
    public void writeToBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        LittleEndian.putInt(byArray, this._offset, this._value);
    }

    @Override
    public String toString() {
        return String.valueOf(this._value);
    }
}

