/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AreaI;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public abstract class AreaPtgBase
extends OperandPtg
implements AreaI {
    private int field_1_first_row;
    private int field_2_last_row;
    private int field_3_first_column;
    private int field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected AreaPtgBase() {
    }

    protected AreaPtgBase(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (n2 > n) {
            this.setFirstRow(n);
            this.setLastRow(n2);
            this.setFirstRowRelative(bl);
            this.setLastRowRelative(bl2);
        } else {
            this.setFirstRow(n2);
            this.setLastRow(n);
            this.setFirstRowRelative(bl2);
            this.setLastRowRelative(bl);
        }
        if (n4 > n3) {
            this.setFirstColumn(n3);
            this.setLastColumn(n4);
            this.setFirstColRelative(bl3);
            this.setLastColRelative(bl4);
        } else {
            this.setFirstColumn(n4);
            this.setLastColumn(n3);
            this.setFirstColRelative(bl4);
            this.setLastColRelative(bl3);
        }
    }

    protected final void readCoordinates(LittleEndianInput littleEndianInput) {
        this.field_1_first_row = littleEndianInput.readUShort();
        this.field_2_last_row = littleEndianInput.readUShort();
        this.field_3_first_column = littleEndianInput.readUShort();
        this.field_4_last_column = littleEndianInput.readUShort();
    }

    protected final void writeCoordinates(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_first_row);
        littleEndianOutput.writeShort(this.field_2_last_row);
        littleEndianOutput.writeShort(this.field_3_first_column);
        littleEndianOutput.writeShort(this.field_4_last_column);
    }

    @Override
    public final int getFirstRow() {
        return this.field_1_first_row;
    }

    public final void setFirstRow(int n) {
        this.field_1_first_row = n;
    }

    @Override
    public final int getLastRow() {
        return this.field_2_last_row;
    }

    public final void setLastRow(int n) {
        this.field_2_last_row = n;
    }

    @Override
    public final int getFirstColumn() {
        return columnMask.getValue(this.field_3_first_column);
    }

    public final boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstRowRelative(boolean bl) {
        this.field_3_first_column = rowRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstColRelative(boolean bl) {
        this.field_3_first_column = colRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final void setFirstColumn(int n) {
        this.field_3_first_column = columnMask.setValue(this.field_3_first_column, n);
    }

    @Override
    public final int getLastColumn() {
        return columnMask.getValue(this.field_4_last_column);
    }

    public final boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public final void setLastRowRelative(boolean bl) {
        this.field_4_last_column = rowRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public final void setLastColRelative(boolean bl) {
        this.field_4_last_column = colRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final void setLastColumn(int n) {
        this.field_4_last_column = columnMask.setValue(this.field_4_last_column, n);
    }

    protected final String formatReferenceAsString() {
        CellReference cellReference;
        CellReference cellReference2 = new CellReference(this.getFirstRow(), this.getFirstColumn(), !this.isFirstRowRelative(), !this.isFirstColRelative());
        if (AreaReference.isWholeColumnReference(cellReference2, cellReference = new CellReference(this.getLastRow(), this.getLastColumn(), !this.isLastRowRelative(), !this.isLastColRelative()))) {
            return new AreaReference(cellReference2, cellReference).formatAsString();
        }
        return cellReference2.formatAsString() + ":" + cellReference.formatAsString();
    }

    @Override
    public String toFormulaString() {
        return this.formatReferenceAsString();
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }
}

