/*
 * Decompiled with CFR 0.152.
 */
package mergeoverlap;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mergeoverlap.hack.MyCombinePrimitiveResolverDialog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class MergeOverlapAction
extends JosmAction {
    Map<Way, List<Relation>> relations = new HashMap<Way, List<Relation>>();
    Map<Way, Way> oldWays = new HashMap<Way, Way>();
    Map<Relation, Relation> newRelations = new HashMap<Relation, Relation>();
    Set<Way> deletes = new HashSet<Way>();

    public MergeOverlapAction() {
        super(I18n.tr((String)"Merge overlap", (Object[])new Object[0]), "merge_overlap", I18n.tr((String)"Merge overlap of ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:mergeoverlap", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Merge overlap", (Object[])new Object[0])}), (int)79, (int)5008), true);
    }

    public void actionPerformed(ActionEvent e) {
        Object way;
        ArrayList<Way> ways = new ArrayList<Way>();
        this.relations.clear();
        this.newRelations.clear();
        for (OsmPrimitive osm : this.getLayerManager().getEditDataSet().getSelected()) {
            if (!(osm instanceof Way) || osm.isDeleted()) continue;
            way = (Way)osm;
            ways.add((Way)way);
            ArrayList<Relation> rels = new ArrayList<Relation>();
            for (Relation r : OsmPrimitive.getFilteredList((Collection)way.getReferrers(), Relation.class)) {
                rels.add(r);
            }
            this.relations.put((Way)way, rels);
        }
        ArrayList<Way> sel = new ArrayList<Way>(ways);
        LinkedList<Object> cmds = new LinkedList<Object>();
        for (Way way2 : ways) {
            HashSet nodes = new HashSet();
            for (Way opositWay : ways) {
                if (way2 == opositWay) continue;
                LinkedList<NodePos> nodesPos = new LinkedList<NodePos>();
                int pos = 0;
                for (Node node : way2.getNodes()) {
                    int opositPos = 0;
                    for (Node opositNode : opositWay.getNodes()) {
                        if (node == opositNode) {
                            if (opositWay.isClosed()) {
                                opositPos %= opositWay.getNodesCount() - 1;
                            }
                            nodesPos.add(new NodePos(node, pos, opositPos));
                            break;
                        }
                        ++opositPos;
                    }
                    ++pos;
                }
                NodePos start = null;
                NodePos end = null;
                int increment = 0;
                boolean hasFirst = false;
                for (NodePos node : nodesPos) {
                    if (start == null) {
                        start = node;
                        continue;
                    }
                    if (end == null) {
                        if (this.follows(way2, opositWay, start, node, 1)) {
                            end = node;
                            increment = 1;
                            continue;
                        }
                        if (this.follows(way2, opositWay, start, node, -1)) {
                            end = node;
                            increment = -1;
                            continue;
                        }
                        start = node;
                        end = null;
                        continue;
                    }
                    if (this.follows(way2, opositWay, end, node, increment)) {
                        end = node;
                        continue;
                    }
                    hasFirst = this.addNodes(start, end, way2, nodes, hasFirst);
                    start = node;
                    end = null;
                }
                if (start == null || end == null) continue;
                hasFirst = this.addNodes(start, end, way2, nodes, hasFirst);
                start = null;
                end = null;
            }
            if ((nodes.isEmpty() || way2.isClosed()) && nodes.size() < 2) continue;
            List wayChunks = SplitWayCommand.buildSplitChunks((Way)way2, new ArrayList(nodes));
            SplitWayCommand result = SplitWayCommand.splitWay((Way)way2, (List)wayChunks, Collections.emptyList());
            cmds.add(result);
            sel.remove(way2);
            sel.add(result.getOriginalWay());
            sel.addAll(result.getNewWays());
            List<Relation> rels = this.relations.remove(way2);
            this.relations.put(result.getOriginalWay(), rels);
            for (Way w : result.getNewWays()) {
                this.relations.put(w, rels);
            }
        }
        ways = new ArrayList(sel);
        while (!ways.isEmpty()) {
            Pair<Way, List<Command>> combineResult;
            way = (Way)ways.get(0);
            ArrayList<Way> combine = new ArrayList<Way>();
            combine.add((Way)way);
            for (Way opositWay : ways) {
                if (way == opositWay || way.getNodesCount() != opositWay.getNodesCount()) continue;
                boolean equals1 = true;
                for (int i = 0; i < way.getNodesCount(); ++i) {
                    if (way.getNode(i) == opositWay.getNode(i)) continue;
                    equals1 = false;
                    break;
                }
                boolean equals2 = true;
                for (int i = 0; i < way.getNodesCount(); ++i) {
                    if (way.getNode(i) == opositWay.getNode(way.getNodesCount() - i - 1)) continue;
                    equals2 = false;
                    break;
                }
                if (!equals1 && !equals2) continue;
                combine.add(opositWay);
            }
            ways.removeAll(combine);
            if (combine.size() <= 1) continue;
            sel.removeAll(combine);
            try {
                combineResult = this.combineWaysWorker(combine);
            }
            catch (UserCancelException ex) {
                return;
            }
            sel.add((Way)combineResult.a);
            cmds.addAll((Collection)combineResult.b);
        }
        for (Relation old : this.newRelations.keySet()) {
            cmds.add(new ChangeCommand((OsmPrimitive)old, (OsmPrimitive)this.newRelations.get(old)));
        }
        LinkedList<Way> del = new LinkedList<Way>();
        for (Way w : this.deletes) {
            if (w.getDataSet() == null || w.isDeleted()) continue;
            del.add(w);
        }
        if (!del.isEmpty()) {
            cmds.add(new DeleteCommand(del));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Merge Overlap (combine)", (Object[])new Object[0]), cmds));
        this.getLayerManager().getEditDataSet().setSelected(sel);
        MainApplication.getMap().repaint();
        this.relations.clear();
        this.newRelations.clear();
        this.oldWays.clear();
    }

    private boolean addNodes(NodePos start, NodePos end, Way way, Set<Node> nodes, boolean hasFirst) {
        if (way.isClosed() || start.node != way.getNode(0) && start.node != way.getNode(way.getNodesCount() - 1)) {
            hasFirst = hasFirst || start.node == way.getNode(0);
            nodes.add(start.node);
        }
        if (way.isClosed() || end.node != way.getNode(0) && end.node != way.getNode(way.getNodesCount() - 1)) {
            if (hasFirst && end.node == way.getNode(way.getNodesCount() - 1)) {
                nodes.remove(way.getNode(0));
            } else {
                nodes.add(end.node);
            }
        }
        return hasFirst;
    }

    private boolean follows(Way way1, Way way2, NodePos np1, NodePos np2, int incr) {
        if (way2.isClosed() && incr == 1 && np1.opositPos == way2.getNodesCount() - 2) {
            return np2.pos == np1.pos + 1 && np2.opositPos == 0;
        }
        if (way2.isClosed() && incr == 1 && np1.opositPos == 0) {
            return np2.pos == np1.pos && np2.opositPos == 0 || np2.pos == np1.pos + 1 && np2.opositPos == 1;
        }
        if (way2.isClosed() && incr == -1 && np1.opositPos == 0) {
            return np2.pos == np1.pos && np2.opositPos == 0 || np2.pos == np1.pos + 1 && np2.opositPos == way2.getNodesCount() - 2;
        }
        return np2.pos == np1.pos + 1 && np2.opositPos == np1.opositPos + incr;
    }

    private Pair<Way, List<Command>> combineWaysWorker(Collection<Way> ways) throws UserCancelException {
        if (ways == null || ways.isEmpty()) {
            return null;
        }
        ways.remove(null);
        ways = new LinkedHashSet<Way>(ways);
        NodeGraph graph = NodeGraph.createUndirectedGraphFromNodeWays(ways);
        List path = graph.buildSpanningPath();
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        List<Way> reversedWays = new LinkedList();
        List<Way> unreversedWays = new LinkedList();
        for (Way w : ways) {
            if (path.indexOf(w.getNode(0)) + 1 == path.lastIndexOf(w.getNode(1))) {
                unreversedWays.add(w);
                continue;
            }
            reversedWays.add(w);
        }
        if (unreversedWays.isEmpty()) {
            Collections.reverse(path);
            unreversedWays = reversedWays;
            reversedWays = null;
        }
        if (reversedWays != null && !reversedWays.isEmpty()) {
            unreversedWays = ReverseWayTagCorrector.irreversibleWays(unreversedWays);
            if ((reversedWays = ReverseWayTagCorrector.irreversibleWays(reversedWays)).size() > unreversedWays.size()) {
                Collections.reverse(path);
                List<Way> tempWays = unreversedWays;
                unreversedWays = reversedWays;
                reversedWays = tempWays;
            }
            if (!reversedWays.isEmpty()) {
                ArrayList<Way> unreversedTagWays = new ArrayList<Way>(ways);
                unreversedTagWays.removeAll(reversedWays);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                ArrayList<Way> reversedTagWays = new ArrayList<Way>();
                Collection changePropertyCommands = null;
                for (Way w : reversedWays) {
                    Way wnew = new Way(w);
                    reversedTagWays.add(wnew);
                    changePropertyCommands = reverseWayTagCorrector.execute(w, wnew);
                }
                if (changePropertyCommands != null && !changePropertyCommands.isEmpty()) {
                    for (Command c : changePropertyCommands) {
                        c.executeCommand();
                    }
                }
                wayTags = TagCollection.unionOfAllPrimitives(reversedTagWays);
                wayTags.add(TagCollection.unionOfAllPrimitives(unreversedTagWays));
            }
        }
        Way targetWay = MergeOverlapAction.getTargetWay(ways);
        Way modifiedTargetWay = new Way(targetWay);
        modifiedTargetWay.setNodes(path);
        TagCollection completeWayTags = new TagCollection(wayTags);
        TagConflictResolutionUtil.applyAutomaticTagConflictResolution((TagCollection)completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)completeWayTags, ways);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing((TagCollection)tagsToEdit);
        MyCombinePrimitiveResolverDialog dialog = MyCombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues());
        dialog.setTargetPrimitive((OsmPrimitive)targetWay);
        Set<Relation> parentRelations = this.getParentRelations(ways);
        dialog.getRelationMemberConflictResolverModel().populate(parentRelations, ways, this.oldWays);
        dialog.prepareDefaultDecisions();
        if (MergeOverlapAction.askForMergeTag(ways) || this.duplicateParentRelations(ways)) {
            dialog.setVisible(true);
            if (!dialog.isApplied()) {
                throw new UserCancelException();
            }
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        this.deletes.addAll(ways);
        this.deletes.remove(targetWay);
        cmds.add(new ChangeCommand((OsmPrimitive)targetWay, (OsmPrimitive)modifiedTargetWay));
        cmds.addAll(dialog.buildWayResolutionCommands());
        dialog.buildRelationCorrespondance(this.newRelations, this.oldWays);
        return new Pair((Object)targetWay, cmds);
    }

    private static Way getTargetWay(Collection<Way> combinedWays) {
        Way targetWay = combinedWays.iterator().next();
        Iterator<Way> iterator = combinedWays.iterator();
        while (iterator.hasNext()) {
            Way w;
            targetWay = w = iterator.next();
            if (w.isNew()) continue;
            break;
        }
        return targetWay;
    }

    private static boolean askForMergeTag(Collection<Way> ways) {
        for (Way way : ways) {
            for (Way oposite : ways) {
                for (String key : way.getKeys().keySet()) {
                    if ("source".equals(key) || !oposite.hasKey(key) || way.get(key).equals(oposite.get(key))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean duplicateParentRelations(Collection<Way> ways) {
        HashSet<Relation> relations = new HashSet<Relation>();
        for (Way w : ways) {
            List<Relation> rs = this.getParentRelations(w);
            for (Relation r : rs) {
                if (!relations.contains(r)) continue;
                return true;
            }
            relations.addAll(rs);
        }
        return false;
    }

    private List<Relation> getParentRelations(Way way) {
        ArrayList<Relation> rels = new ArrayList<Relation>();
        for (Relation r : this.relations.get(way)) {
            if (this.newRelations.containsKey(r)) {
                rels.add(this.newRelations.get(r));
                continue;
            }
            rels.add(r);
        }
        return rels;
    }

    public static Relation getNew(Relation r, Map<Relation, Relation> newRelations) {
        if (newRelations.containsValue(r)) {
            return r;
        }
        Relation c = new Relation(r);
        newRelations.put(r, c);
        return c;
    }

    public static Way getOld(Way w, Map<Way, Way> oldWays) {
        if (oldWays.containsKey(w)) {
            return oldWays.get(w);
        }
        return w;
    }

    private Set<Relation> getParentRelations(Collection<Way> ways) {
        HashSet<Relation> ret = new HashSet<Relation>();
        for (Way w : ways) {
            ret.addAll(this.getParentRelations(w));
        }
        return ret;
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way && !osmPrimitive.isDeleted()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selection.size() >= 2);
    }

    private static class NodePos {
        Node node;
        int pos;
        int opositPos;

        NodePos(Node n, int p, int op) {
            this.node = n;
            this.pos = p;
            this.opositPos = op;
        }

        public String toString() {
            return "NodePos: " + this.pos + ", " + this.opositPos + ", " + this.node;
        }
    }
}

