/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class CacheWeakSoftRef
extends EngineWrapper
implements Engine {
    protected final ReentrantLock[] locks = Utils.newLocks(32);
    protected ReferenceQueue queue = new ReferenceQueue();
    protected Thread queueThread = new Thread("MapDB GC collector"){

        @Override
        public void run() {
            CacheWeakSoftRef.this.runRefQueue();
        }
    };
    protected LongConcurrentHashMap<CacheItem> items = new LongConcurrentHashMap();
    protected final boolean useWeakRef;

    public CacheWeakSoftRef(Engine engine, boolean useWeakRef) {
        super(engine);
        this.useWeakRef = useWeakRef;
        this.queueThread.setDaemon(true);
        this.queueThread.start();
    }

    protected void runRefQueue() {
        try {
            ReferenceQueue queue = this.queue;
            LongConcurrentHashMap<CacheItem> items = this.items;
            do {
                CacheItem item = (CacheItem)((Object)queue.remove());
                items.remove(item.getRecid(), item);
            } while (!Thread.interrupted());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = this.getWrappedEngine().put(value, serializer);
        this.putItemIntoCache(recid, value);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        LongConcurrentHashMap<CacheItem> items2 = CacheWeakSoftRef.checkClosed(this.items);
        CacheItem item = items2.get(recid);
        if (item != null) {
            Object o = item.get();
            if (o == null) {
                items2.remove(recid);
            } else {
                return (A)o;
            }
        }
        try {
            Utils.lock(this.locks, recid);
            A value = this.getWrappedEngine().get(recid, serializer);
            if (value != null) {
                this.putItemIntoCache(recid, value);
            }
            A a = value;
            return a;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            Utils.lock(this.locks, recid);
            this.putItemIntoCache(recid, value);
            this.getWrappedEngine().update(recid, value, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    private <A> void putItemIntoCache(long recid, A value) {
        ReferenceQueue q = CacheWeakSoftRef.checkClosed(this.queue);
        CacheWeakSoftRef.checkClosed(this.items).put(recid, (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<A>(value, q, recid) : new CacheSoftItem<A>(value, q, recid))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        try {
            Utils.lock(this.locks, recid);
            CacheWeakSoftRef.checkClosed(this.items).remove(recid);
            this.getWrappedEngine().delete(recid, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            Object oldValue;
            Utils.lock(this.locks, recid);
            CacheItem item = CacheWeakSoftRef.checkClosed(this.items).get(recid);
            Object object = oldValue = item == null ? null : item.get();
            if (item != null && item.getRecid() == recid && (oldValue == expectedOldValue || oldValue.equals(expectedOldValue))) {
                this.putItemIntoCache(recid, newValue);
                this.getWrappedEngine().update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean ret = this.getWrappedEngine().compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                this.putItemIntoCache(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    @Override
    public void close() {
        super.close();
        this.items = null;
        this.queue = null;
        if (this.queueThread != null) {
            this.queueThread.interrupt();
            this.queueThread = null;
        }
    }

    @Override
    public void rollback() {
        this.items.clear();
        super.rollback();
    }

    protected static final class CacheSoftItem<A>
    extends SoftReference<A>
    implements CacheItem {
        final long recid;

        public CacheSoftItem(A referent, ReferenceQueue<A> q, long recid) {
            super(referent, q);
            this.recid = recid;
        }

        @Override
        public long getRecid() {
            return this.recid;
        }
    }

    protected static final class CacheWeakItem<A>
    extends WeakReference<A>
    implements CacheItem {
        final long recid;

        public CacheWeakItem(A referent, ReferenceQueue<A> q, long recid) {
            super(referent, q);
            this.recid = recid;
        }

        @Override
        public long getRecid() {
            return this.recid;
        }
    }

    protected static interface CacheItem {
        public long getRecid();

        public Object get();
    }
}

