/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentLRUMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class CacheLRU
extends EngineWrapper {
    protected LongMap<Object> cache;
    protected final ReentrantLock[] locks = Utils.newLocks(32);

    public CacheLRU(Engine engine, int cacheSize) {
        this(engine, new LongConcurrentLRUMap<Object>(cacheSize, (int)((double)cacheSize * 0.8)));
    }

    public CacheLRU(Engine engine, LongMap<Object> cache) {
        super(engine);
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = super.put(value, serializer);
        try {
            Utils.lock(this.locks, recid);
            CacheLRU.checkClosed(this.cache).put(recid, value);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        Object ret = this.cache.get(recid);
        if (ret != null) {
            return (A)ret;
        }
        try {
            Utils.lock(this.locks, recid);
            ret = super.get(recid, serializer);
            if (ret != null) {
                CacheLRU.checkClosed(this.cache).put(recid, ret);
            }
            Object object = ret;
            return (A)object;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            Utils.lock(this.locks, recid);
            CacheLRU.checkClosed(this.cache).put(recid, value);
            super.update(recid, value, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        try {
            Utils.lock(this.locks, recid);
            CacheLRU.checkClosed(this.cache).remove(recid);
            super.delete(recid, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            Utils.lock(this.locks, recid);
            Engine engine = this.getWrappedEngine();
            LongMap<Object> cache2 = CacheLRU.checkClosed(this.cache);
            Object oldValue = this.cache.get(recid);
            if (oldValue == expectedOldValue || oldValue.equals(expectedOldValue)) {
                cache2.put(recid, newValue);
                engine.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean ret = engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                cache2.put(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    @Override
    public void close() {
        LongMap<Object> cache2 = this.cache;
        if (cache2 instanceof LongConcurrentLRUMap) {
            ((LongConcurrentLRUMap)cache2).destroy();
        }
        this.cache = null;
        super.close();
    }

    @Override
    public void rollback() {
        CacheLRU.checkClosed(this.cache).clear();
        super.rollback();
    }
}

