/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.mapdb.SerializerBase;

public final class DataOutput2
implements DataOutput {
    byte[] buf = new byte[16];
    int pos = 0;

    DataOutput2() {
    }

    byte[] copyBytes() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    private void ensureAvail(int n) {
        if (this.pos + n >= this.buf.length) {
            int newSize = Math.max(this.pos + n, this.buf.length * 2);
            this.buf = Arrays.copyOf(this.buf, newSize);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureAvail(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureAvail(2);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeInt(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvail(4);
        this.buf[this.pos++] = (byte)(0xFF & v >> 24);
        this.buf[this.pos++] = (byte)(0xFF & v >> 16);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvail(8);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 56);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 48);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 40);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 32);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 24);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 16);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 8);
        this.buf[this.pos++] = (byte)(0xFFL & v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensureAvail(4);
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensureAvail(8);
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        SerializerBase.serializeString(this, s);
    }
}

