/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class McBrydeThomasFlatPolarParabolicProjection
extends Projection {
    private static final double CS = 0.9525793444156804;
    private static final double FXC = 0.9258200997725514;
    private static final double FYC = 3.401680257083045;
    private static final double C23 = 0.6666666666666666;
    private static final double C13 = 0.3333333333333333;
    private static final double ONEEPS = 1.0000001;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.y = Math.asin(0.9525793444156804 * Math.sin(lpphi));
        out.x = 0.9258200997725514 * lplam * (2.0 * Math.cos(0.6666666666666666 * lpphi) - 1.0);
        out.y = 3.401680257083045 * Math.sin(0.3333333333333333 * lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double d;
        out.y = xyy / 3.401680257083045;
        if (Math.abs(out.y) >= 1.0) {
            if (Math.abs(out.y) > 1.0000001) {
                throw new ProjectionException("I");
            }
            out.y = out.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            out.y = Math.asin(out.y);
        }
        out.x = xyx / (0.9258200997725514 * (2.0 * Math.cos(0.6666666666666666 * (out.y *= 3.0)) - 1.0));
        out.y = Math.sin(out.y) / 0.9525793444156804;
        if (Math.abs(d) >= 1.0) {
            if (Math.abs(out.y) > 1.0000001) {
                throw new ProjectionException("I");
            }
            out.y = out.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            out.y = Math.asin(out.y);
        }
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "McBride-Thomas Flat-Polar Parabolic";
    }
}

