/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.io.File;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.JunctionChecker.ChannelDiGraphLayer;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckDialog;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerMapMode;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.ColorSchemeXMLReader;
import org.openstreetmap.josm.plugins.JunctionChecker.util.RelationProducer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class JunctionCheckerPlugin
extends Plugin
implements LayerManager.LayerChangeListener {
    private static final String COLORSCHEMEFILTERFILE = "/resources/xml/colorscheme.xml";
    private JunctionCheckDialog junctionCheckDialog;
    private File pathDir;
    private final RelationProducer relationproducer;
    private OsmDataLayer osmlayer;
    private ChannelDiGraphLayer channelDigraphLayer;
    private final ColorSchemeXMLReader cXMLReaderMK;
    private ChannelDiGraph channelDigraph;
    private final JunctionCheckerMapMode jcMapMode = new JunctionCheckerMapMode("junctionchecking", I18n.tr((String)"construct channel digraph and search for junctions", (Object[])new Object[0]));
    private MapMode normalMapMode;

    public JunctionCheckerPlugin(PluginInformation info) {
        super(info);
        this.relationproducer = new RelationProducer(this);
        this.cXMLReaderMK = new ColorSchemeXMLReader(COLORSCHEMEFILTERFILE);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.jcMapMode.setFrame(newFrame);
        if (newFrame != null) {
            this.junctionCheckDialog = new JunctionCheckDialog(this);
            newFrame.addToggleDialog((ToggleDialog)this.junctionCheckDialog);
            MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        } else {
            MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.getJunctionCheckDialog().setActivateCreateDigraph(true);
            this.getJunctionCheckDialog().setActivateJunctionCheckOrSearch(false);
            if (this.normalMapMode != null) {
                MainApplication.getMap().selectMapMode(this.normalMapMode);
            }
        } else if (newLayer instanceof ChannelDiGraphLayer) {
            this.getJunctionCheckDialog().setActivateCreateDigraph(false);
            this.getJunctionCheckDialog().setActivateJunctionCheckOrSearch(true);
            MainApplication.getMap().selectMapMode((MapMode)this.jcMapMode);
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() == this.channelDigraphLayer) {
            this.channelDigraphLayer = null;
            this.getJunctionCheckDialog().setActivateJunctionCheckOrSearch(false);
            return;
        }
        this.getJunctionCheckDialog().setActivateCreateDigraph(false);
    }

    public ChannelDiGraphLayer getChannelDigraphLayer() {
        if (this.channelDigraphLayer == null) {
            this.channelDigraphLayer = new ChannelDiGraphLayer(this.cXMLReaderMK);
        }
        return this.channelDigraphLayer;
    }

    public JunctionCheckDialog getJunctionCheckDialog() {
        return this.junctionCheckDialog;
    }

    public File getPathDir() {
        return this.pathDir;
    }

    public OsmDataLayer getOsmlayer() {
        return this.osmlayer;
    }

    public void setOsmlayer(OsmDataLayer osmlayer) {
        this.osmlayer = osmlayer;
    }

    public RelationProducer getRelationProducer() {
        return this.relationproducer;
    }

    public ChannelDiGraph getChannelDigraph() {
        return this.channelDigraph;
    }

    public void setChannelDigraph(ChannelDiGraph channelDigraph) {
        this.channelDigraph = channelDigraph;
    }

    public JunctionCheckerMapMode getJcMapMode() {
        return this.jcMapMode;
    }

    public void setNormalMapMode(MapMode mm) {
        this.normalMapMode = mm;
    }
}

