/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.SchemaObject;
import org.hsqldb.types.Type;

public class Token {
    String tokenString = "";
    int tokenType = -1;
    Type dataType;
    Object tokenValue;
    String namePrefix;
    String namePrePrefix;
    String namePrePrePrefix;
    String charsetSchema;
    String charsetName;
    String fullString;
    int lobMultiplierType = -1;
    boolean isDelimiter;
    boolean isDelimitedIdentifier;
    boolean isDelimitedPrefix;
    boolean isDelimitedPrePrefix;
    boolean isDelimitedPrePrePrefix;
    boolean isUndelimitedIdentifier;
    boolean hasIrregularChar;
    boolean isReservedIdentifier;
    boolean isCoreReservedIdentifier;
    boolean isHostParameter;
    boolean isMalformed;
    int position;
    Object expression;

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.namePrefix = null;
        this.namePrePrefix = null;
        this.namePrePrePrefix = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.expression = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isDelimitedPrefix = false;
        this.isDelimitedPrePrefix = false;
        this.isDelimitedPrePrePrefix = false;
        this.isUndelimitedIdentifier = false;
        this.hasIrregularChar = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
    }

    Token duplicate() {
        Token token = new Token();
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.namePrefix = this.namePrefix;
        token.namePrePrefix = this.namePrePrefix;
        token.namePrePrePrefix = this.namePrePrePrefix;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isDelimitedPrefix = this.isDelimitedPrefix;
        token.isDelimitedPrePrefix = this.isDelimitedPrePrefix;
        token.isDelimitedPrePrePrefix = this.isDelimitedPrePrePrefix;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.hasIrregularChar = this.hasIrregularChar;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
        return token;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setExpression(Object object) {
        this.expression = object;
    }

    String getSQL() {
        if (this.expression instanceof ExpressionColumn) {
            if (this.tokenType == 801) {
                StringBuffer stringBuffer = new StringBuffer();
                Expression expression = (Expression)this.expression;
                if (expression != null && expression.opType == 97 && expression.nodes.length > 0) {
                    stringBuffer.append(' ');
                    for (int i = 0; i < expression.nodes.length; ++i) {
                        String string;
                        Expression expression2 = expression.nodes[i];
                        ColumnSchema columnSchema = expression2.getColumn();
                        if (expression2.opType == 3) {
                            if (i > 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(expression2.getColumnName());
                            continue;
                        }
                        if (expression2.getRangeVariable().tableAlias == null) {
                            string = columnSchema.getName().getSchemaQualifiedStatementName();
                        } else {
                            RangeVariable rangeVariable = expression2.getRangeVariable();
                            string = rangeVariable.tableAlias.getStatementName() + '.' + columnSchema.getName().statementName;
                        }
                        if (i > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(string);
                    }
                } else {
                    return this.tokenString;
                }
                stringBuffer.append(' ');
                return stringBuffer.toString();
            }
        } else {
            if (this.expression instanceof Type) {
                this.isDelimiter = false;
                Type type = (Type)this.expression;
                if (type.isDistinctType() || type.isDomainType()) {
                    return type.getName().getSchemaQualifiedStatementName();
                }
                return type.getNameString();
            }
            if (this.expression instanceof SchemaObject) {
                this.isDelimiter = false;
                return ((SchemaObject)this.expression).getName().getSchemaQualifiedStatementName();
            }
        }
        if (this.namePrefix == null && this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 869) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.namePrePrefix != null) {
            if (this.isDelimitedPrePrefix) {
                stringBuffer.append('\"');
                stringBuffer.append(this.namePrePrefix);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(this.namePrePrefix);
            }
            stringBuffer.append('.');
        }
        if (this.namePrefix != null) {
            if (this.isDelimitedPrefix) {
                stringBuffer.append('\"');
                stringBuffer.append(this.namePrefix);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(this.namePrefix);
            }
            stringBuffer.append('.');
        }
        if (this.isDelimitedIdentifier) {
            stringBuffer.append('\"');
            stringBuffer.append(this.tokenString);
            stringBuffer.append('\"');
            this.isDelimiter = false;
        } else {
            stringBuffer.append(this.tokenString);
        }
        return stringBuffer.toString();
    }

    static String getSQL(Token[] tokenArray) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < tokenArray.length; ++i) {
            String string = tokenArray[i].getSQL();
            if (!tokenArray[i].isDelimiter && !bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            bl = tokenArray[i].isDelimiter;
        }
        return stringBuffer.toString();
    }

    static Object[] getSimplifiedTokens(Token[] tokenArray) {
        Object[] objectArray = new Object[tokenArray.length];
        for (int i = 0; i < tokenArray.length; ++i) {
            objectArray[i] = tokenArray[i].expression == null ? tokenArray[i].getSQL() : tokenArray[i].expression;
        }
        return objectArray;
    }
}

