/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Date;
import java.util.List;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.InternalFunction;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.parameter.Parameter;
import org.opengis.temporal.Period;

public class BindingFilterVisitor
extends DuplicatingFilterVisitor {
    FeatureType schema;
    private ExpressionTypeVisitor expressionTypeVisitor;

    public BindingFilterVisitor(FeatureType schema) {
        this.schema = schema;
        this.expressionTypeVisitor = new ExpressionTypeVisitor(schema);
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).equal(expr1, expr2, matchCase, filter.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).notEqual(expr1, expr2, matchCase, filter.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getLowerBoundary(), filter.getExpression(), filter.getUpperBoundary());
        Expression lb = this.optimize(filter.getLowerBoundary(), extraData, targetType);
        Expression ex = this.optimize(filter.getExpression(), extraData, targetType);
        Expression ub = this.optimize(filter.getUpperBoundary(), extraData, targetType);
        return this.getFactory(extraData).between(ex, lb, ub, filter.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).greater(expr1, expr2, matchCase, filter.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).greaterOrEqual(expr1, expr2, matchCase, filter.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).less(expr1, expr2, matchCase, filter.getMatchAction());
    }

    @Override
    public Object visit(Function expression, Object extraData) {
        List<Expression> old = expression.getParameters();
        FunctionName functionName = expression.getFunctionName();
        List<Parameter<?>> arguments = null;
        if (functionName != null) {
            arguments = functionName.getArguments();
        }
        Expression[] args = new Expression[old.size()];
        for (int i = 0; i < old.size(); ++i) {
            Expression exp = old.get(i);
            args[i] = arguments != null && i < arguments.size() ? this.optimize(exp, extraData, arguments.get(i).getType()) : this.visit(exp, extraData);
        }
        Function duplicate = expression instanceof InternalFunction ? ((InternalFunction)expression).duplicate(args) : this.getFactory(extraData).function(expression.getName(), args);
        return duplicate;
    }

    @Override
    public Object visit(After after, Object extraData) {
        Expression expr1 = this.optimizeTime(after.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(after.getExpression2(), extraData);
        return this.getFactory(extraData).after(expr1, expr2, after.getMatchAction());
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        Expression expr1 = this.optimizeTime(anyInteracts.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(anyInteracts.getExpression2(), extraData);
        return this.getFactory(extraData).anyInteracts(expr1, expr2, anyInteracts.getMatchAction());
    }

    @Override
    public Object visit(Before before, Object extraData) {
        Expression expr1 = this.optimizeTime(before.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(before.getExpression2(), extraData);
        return this.getFactory(extraData).before(expr1, expr2, before.getMatchAction());
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        Expression expr1 = this.optimizeTime(begins.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(begins.getExpression2(), extraData);
        return this.getFactory(extraData).begins(expr1, expr2, begins.getMatchAction());
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        Expression expr1 = this.optimizeTime(begunBy.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(begunBy.getExpression2(), extraData);
        return this.getFactory(extraData).begins(expr1, expr2, begunBy.getMatchAction());
    }

    @Override
    public Object visit(During during, Object extraData) {
        Expression expr1 = this.optimizeTime(during.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(during.getExpression2(), extraData);
        return this.getFactory(extraData).during(expr1, expr2, during.getMatchAction());
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        Expression expr1 = this.optimizeTime(endedBy.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(endedBy.getExpression2(), extraData);
        return this.getFactory(extraData).endedBy(expr1, expr2, endedBy.getMatchAction());
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        Expression expr1 = this.optimizeTime(ends.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(ends.getExpression2(), extraData);
        return this.getFactory(extraData).ends(expr1, expr2, ends.getMatchAction());
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        Expression expr1 = this.optimizeTime(meets.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(meets.getExpression2(), extraData);
        return this.getFactory(extraData).meets(expr1, expr2, meets.getMatchAction());
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        Expression expr1 = this.optimizeTime(metBy.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(metBy.getExpression2(), extraData);
        return this.getFactory(extraData).metBy(expr1, expr2, metBy.getMatchAction());
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        Expression expr1 = this.optimizeTime(overlappedBy.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(overlappedBy.getExpression2(), extraData);
        return this.getFactory(extraData).overlappedBy(expr1, expr2, overlappedBy.getMatchAction());
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        Expression expr1 = this.optimizeTime(contains.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(contains.getExpression2(), extraData);
        return this.getFactory(extraData).tcontains(expr1, expr2, contains.getMatchAction());
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        Expression expr1 = this.optimizeTime(equals.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(equals.getExpression2(), extraData);
        return this.getFactory(extraData).tequals(expr1, expr2, equals.getMatchAction());
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        Expression expr1 = this.optimizeTime(contains.getExpression1(), extraData);
        Expression expr2 = this.optimizeTime(contains.getExpression2(), extraData);
        return this.getFactory(extraData).toverlaps(expr1, expr2, contains.getMatchAction());
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        Class targetType = this.getTargetType(filter.getExpression1(), filter.getExpression2());
        Expression expr1 = this.optimize(filter.getExpression1(), extraData, targetType);
        Expression expr2 = this.optimize(filter.getExpression2(), extraData, targetType);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).lessOrEqual(expr1, expr2, matchCase, filter.getMatchAction());
    }

    protected Expression optimize(Expression expression, Object extraData, Class targetType) {
        Object converted;
        if (expression instanceof Literal && targetType != null && (converted = expression.evaluate(null, targetType)) != null) {
            return this.ff.literal(converted);
        }
        return this.visit(expression, extraData);
    }

    protected Expression optimizeTime(Expression expression, Object extraData) {
        if (expression instanceof Literal) {
            Object converted = expression.evaluate(null, Period.class);
            if (converted != null) {
                return this.ff.literal(converted);
            }
            converted = expression.evaluate(null, Date.class);
            if (converted != null) {
                return this.ff.literal(converted);
            }
        }
        return this.visit(expression, extraData);
    }

    private Class getTargetType(Expression ... expressions) {
        Class result = null;
        for (Expression expression : expressions) {
            if (expression instanceof Literal) continue;
            Class target = (Class)expression.accept(this.expressionTypeVisitor, null);
            if (target == null) {
                return target;
            }
            if (result == null) {
                result = target;
                continue;
            }
            if (target.equals(result)) continue;
            return null;
        }
        return result;
    }
}

