/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.IOException;
import org.geotools.data.sort.SimpleFeatureIO;
import org.opengis.feature.simple.SimpleFeature;

class FeatureBlockReader {
    SimpleFeature curr;
    long offset;
    int count;
    SimpleFeatureIO io;

    public FeatureBlockReader(SimpleFeatureIO io, long start, int count) {
        this.offset = start;
        this.count = count;
        this.io = io;
    }

    public SimpleFeature feature() throws IOException {
        if (this.curr == null && this.count > 0) {
            this.curr = this.readNextFeature();
        }
        return this.curr;
    }

    public SimpleFeature next() throws IOException {
        this.curr = this.readNextFeature();
        return this.curr;
    }

    private SimpleFeature readNextFeature() throws IOException {
        if (this.count <= 0) {
            return null;
        }
        this.io.seek(this.offset);
        SimpleFeature sf = this.io.read();
        this.offset = this.io.getOffset();
        --this.count;
        return sf;
    }
}

