/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.customurl;

import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.ChooseURLAction;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.URLList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public final class OpenPageAction
extends JosmAction {
    public OpenPageAction() {
        super(I18n.tr((String)"Open custom URL", (Object[])new Object[0]), "openurl", I18n.tr((String)"Opens specified URL browser", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:openurl", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Open custom URL", (Object[])new Object[0])}), (int)72, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/OpenPage"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = this.getLayerManager().getEditDataSet().getSelected();
        OsmPrimitive p = null;
        if (sel.size() >= 1) {
            p = (OsmPrimitive)sel.iterator().next();
        }
        if (Main.pref.getBoolean("utilsplugin2.askurl", false)) {
            ChooseURLAction.showConfigDialog(true);
        }
        MapView mv = MainApplication.getMap().mapView;
        LatLon center = mv.getLatLon(mv.getWidth() / 2, mv.getHeight() / 2);
        String addr = URLList.getSelectedURL();
        Pattern pat = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = pat.matcher(addr);
        String[] keys = new String[100];
        String[] vals = new String[100];
        int i = 0;
        try {
            while (m.find()) {
                String key = m.group(1);
                String val = null;
                if (key.equals("#id")) {
                    if (p != null) {
                        val = Long.toString(p.getId());
                    }
                } else if (key.equals("#type")) {
                    if (p != null) {
                        val = OsmPrimitiveType.from((IPrimitive)p).getAPIName();
                    }
                } else if (key.equals("#lat")) {
                    val = Double.toString(center.lat());
                } else if (key.equals("#lon")) {
                    val = Double.toString(center.lon());
                } else if (key.equals("#zoom")) {
                    val = Integer.toString(OsmUrlToBounds.getZoom((Bounds)MainApplication.getMap().mapView.getRealBounds()));
                } else if (p != null) {
                    val = p.get(key);
                    if (val != null) {
                        val = URLEncoder.encode(p.get(key), "UTF-8");
                    } else {
                        return;
                    }
                }
                keys[i] = m.group();
                vals[i] = val != null ? val : "";
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)"Encoding error", (Throwable)ex);
            return;
        }
        for (int j = 0; j < i; ++j) {
            addr = addr.replace(keys[j], vals[j]);
        }
        try {
            if (!addr.endsWith("/0/history")) {
                OpenBrowser.displayUrl((String)addr);
            }
        }
        catch (Exception ex) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)("Can not open URL " + addr), (Throwable)ex);
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }
}

