/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import model.IndoorLevel;
import model.TagCatalog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.I18n;
import views.PresetButton;

public class ToolBoxView
extends ToggleDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JToggleButton powerButton;
    private JLabel levelLabel;
    private JosmComboBox<String> levelBox;
    private JLabel levelTagLabel;
    private DisableShortcutsOnFocusGainedTextField levelTagField;
    private JLabel objectLabel;
    private JosmComboBox<TagCatalog.IndoorObject> objectBox;
    private JLabel nameLabel;
    private DisableShortcutsOnFocusGainedTextField nameField;
    private JLabel refLabel;
    private DisableShortcutsOnFocusGainedTextField refField;
    private JPanel buttonBar;
    private JButton applyButton;
    private JSeparator separator1;
    private JSeparator separator2;
    private PresetButton preset1;
    private PresetButton preset2;
    private PresetButton preset3;
    private PresetButton preset4;

    public ToolBoxView() {
        super(I18n.tr((String)"Indoor Mapping Helper", (Object[])new Object[0]), "indoorhelper", I18n.tr((String)"Toolbox for indoor mapping assistance", (Object[])new Object[0]), null, 300, true);
        this.initComponents();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.powerButton = new JToggleButton();
        this.levelLabel = new JLabel();
        this.levelBox = new JosmComboBox();
        this.levelTagLabel = new JLabel();
        this.levelTagField = new DisableShortcutsOnFocusGainedTextField();
        this.objectLabel = new JLabel();
        this.objectBox = new JosmComboBox((Object[])TagCatalog.IndoorObject.values());
        this.nameLabel = new JLabel();
        this.nameField = new DisableShortcutsOnFocusGainedTextField();
        this.refLabel = new JLabel();
        this.refField = new DisableShortcutsOnFocusGainedTextField();
        this.buttonBar = new JPanel();
        this.applyButton = new JButton();
        this.separator1 = new JSeparator();
        this.separator2 = new JSeparator();
        this.preset1 = new PresetButton(TagCatalog.IndoorObject.ROOM);
        this.preset2 = new PresetButton(TagCatalog.IndoorObject.SHELL);
        this.preset3 = new PresetButton(TagCatalog.IndoorObject.CONCRETE_WALL);
        this.preset4 = new PresetButton(TagCatalog.IndoorObject.GLASS_WALL);
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.powerButton.setText(I18n.tr((String)"POWER", (Object[])new Object[0]));
        this.powerButton.setToolTipText(I18n.tr((String)"Activates the plug-in", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.powerButton, new GridBagConstraints(8, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.separator1, new GridBagConstraints(1, 1, 12, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelLabel.setText(I18n.tr((String)"Working Level", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelBox.setEnabled(false);
        this.levelBox.setEditable(false);
        this.levelBox.setToolTipText(I18n.tr((String)"Selects the working level.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelBox, new GridBagConstraints(3, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelTagLabel.setText(I18n.tr((String)"Level Name", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelTagLabel, new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelTagField.setEnabled(false);
        this.levelTagField.setColumns(6);
        this.levelTagField.setToolTipText(I18n.tr((String)"Optional name-tag for a level.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelTagField, new GridBagConstraints(8, 2, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.separator2, new GridBagConstraints(1, 3, 12, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.objectLabel.setText(I18n.tr((String)"Object", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.objectLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.objectBox.setEnabled(false);
        this.objectBox.setPrototypeDisplayValue((Object)TagCatalog.IndoorObject.CONCRETE_WALL);
        this.objectBox.setToolTipText(I18n.tr((String)"The object preset you want to tag.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.objectBox, new GridBagConstraints(3, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.nameLabel.setText(I18n.tr((String)"Name", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.nameField.setEnabled(false);
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ToolBoxView.this.nameField.selectAll();
            }
        });
        this.nameField.setToolTipText(I18n.tr((String)"Sets the name tag when the room-object is selected.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.nameField, new GridBagConstraints(3, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.refLabel.setText(I18n.tr((String)"Reference", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refLabel, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.refField.setEnabled(false);
        this.refField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ToolBoxView.this.refField.selectAll();
            }
        });
        this.refField.setToolTipText(I18n.tr((String)"Sets the ref tag when the room-object is selected.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refField, new GridBagConstraints(3, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.preset1.setEnabled(false);
        this.contentPanel.add((Component)this.preset1, new GridBagConstraints(16, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.separator2, new GridBagConstraints(1, 3, 13, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset2.setEnabled(false);
        this.contentPanel.add((Component)this.preset2, new GridBagConstraints(16, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset3.setEnabled(false);
        this.contentPanel.add((Component)this.preset3, new GridBagConstraints(16, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset4.setEnabled(false);
        this.contentPanel.add((Component)this.preset4, new GridBagConstraints(16, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.applyButton.setText(I18n.tr((String)"Apply Tags", (Object[])new Object[0]));
        this.applyButton.setEnabled(false);
        this.buttonBar.add((Component)this.applyButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.createLayout(this.dialogPane, false, null);
    }

    public boolean getPowerButtonState() {
        return this.powerButton.isSelected();
    }

    public void setAllUiElementsEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.levelBox.setEnabled(enabled);
        this.objectBox.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
        this.refField.setEnabled(enabled);
        this.levelTagField.setEnabled(enabled);
        this.preset1.setEnabled(enabled);
        this.preset2.setEnabled(enabled);
        this.preset3.setEnabled(enabled);
        this.preset4.setEnabled(enabled);
        if (!enabled) {
            this.resetUiElements();
            this.levelTagField.setText("");
        }
    }

    public void setTagUiElementsEnabled(boolean enabled) {
        this.nameField.setEnabled(enabled);
        this.refField.setEnabled(enabled);
        if (!enabled) {
            this.resetUiElements();
        }
    }

    public void setPowerButtonDisabled() {
        this.powerButton.setSelected(false);
    }

    public TagCatalog.IndoorObject getSelectedObject() {
        return (TagCatalog.IndoorObject)((Object)this.objectBox.getSelectedItem());
    }

    public void setLevelList(List<IndoorLevel> levelList) {
        this.levelBox.removeAllItems();
        ListIterator<IndoorLevel> listIterator = levelList.listIterator();
        while (listIterator.hasNext()) {
            IndoorLevel level = listIterator.next();
            if (level.hasEmptyName()) {
                this.levelBox.addItem((Object)Integer.toString(level.getLevelNumber()));
                continue;
            }
            this.levelBox.addItem((Object)level.getName());
        }
    }

    public int getSelectedLevelIndex() {
        return this.levelBox.getSelectedIndex();
    }

    public boolean levelListIsEmpty() {
        return this.levelBox.getItemCount() == 0;
    }

    public String getLevelName() {
        return this.levelTagField.getText();
    }

    public void setLevelName(String name) {
        this.levelTagField.setText(name);
    }

    public String getNameText() {
        return this.nameField.getText();
    }

    public String getRefText() {
        return this.refField.getText();
    }

    public void reset() {
        this.setAllUiElementsEnabled(false);
        this.levelBox.removeAllItems();
    }

    public void resetUiElements() {
        this.nameField.setText("");
        this.refField.setText("");
    }

    public void setPowerButtonListener(ActionListener l) {
        this.powerButton.addActionListener(l);
    }

    public void setApplyButtonListener(ActionListener l) {
        this.applyButton.addActionListener(l);
    }

    public void setLevelItemListener(ItemListener l) {
        this.levelBox.addItemListener(l);
    }

    public void setObjectItemListener(ItemListener l) {
        this.objectBox.addItemListener(l);
    }

    public void setPresetButtons(List<TagCatalog.IndoorObject> objects) {
        this.preset1.setIndoorObject(objects.get(0));
        this.preset2.setIndoorObject(objects.get(1));
        this.preset3.setIndoorObject(objects.get(2));
        this.preset4.setIndoorObject(objects.get(3));
    }

    public void setPreset1Listener(ActionListener l) {
        this.preset1.addActionListener(l);
    }

    public void setPreset2Listener(ActionListener l) {
        this.preset2.addActionListener(l);
    }

    public void setPreset3Listener(ActionListener l) {
        this.preset3.addActionListener(l);
    }

    public void setPreset4Listener(ActionListener l) {
        this.preset4.addActionListener(l);
    }

    public TagCatalog.IndoorObject getPreset1() {
        return this.preset1.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset2() {
        return this.preset2.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset3() {
        return this.preset3.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset4() {
        return this.preset4.getIndoorObject();
    }
}

