/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class QueryWrapperFilter
extends Filter {
    private Query query;

    public QueryWrapperFilter(Query query2) {
        this.query = query2;
    }

    public DocIdSet getDocIdSet(final IndexReader reader) throws IOException {
        final Weight weight = new IndexSearcher(reader).createNormalizedWeight(this.query);
        return new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                return weight.scorer(reader, true, false);
            }

            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "QueryWrapperFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryWrapperFilter)) {
            return false;
        }
        return this.query.equals(((QueryWrapperFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

