/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.plugins.photoadjust.PhotoAdjustWorker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PhotoAdjustMapMode
extends MapMode
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private boolean modeActive = false;
    private boolean modeSelected = false;
    private MouseAdapter mouseAdapter;
    private MouseMotionAdapter mouseMotionAdapter;
    private IconToggleButton mmButton;
    private PhotoAdjustWorker worker;
    private boolean ignoreOneGILayer = false;

    public PhotoAdjustMapMode(PhotoAdjustWorker worker) {
        super(I18n.tr((String)"Adjust photos", (Object[])new Object[0]), "photoadjust.png", I18n.tr((String)"Move and position photos", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:photoadjust", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Adjust photos", (Object[])new Object[0])}), (int)65535, (int)5000), Cursor.getPredefinedCursor(0));
        GeoImageLayer.registerSupportedMapMode((MapMode)this);
        this.initAdapters();
        this.worker = worker;
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public void installMapMode(MapFrame mapFrame) {
        this.mmButton = new IconToggleButton((Action)((Object)this));
        this.mmButton.setAutoHideDisabledButton(true);
        mapFrame.addMapMode(this.mmButton);
    }

    public String getModeHelpText() {
        if (this.hasLayersToAdjust()) {
            return I18n.tr((String)"Click+drag photo, shift+click to position photo, control+click to set direction.", (Object[])new Object[0]);
        }
        return I18n.tr((String)"Please load some photos.", (Object[])new Object[0]);
    }

    public boolean layerIsSupported(Layer layer) {
        return this.hasLayersToAdjust();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.hasLayersToAdjust());
    }

    public void updateButtonState() {
        if (this.mmButton != null) {
            boolean enabled = this.hasLayersToAdjust();
            this.setEnabled(enabled);
            if (enabled) {
                this.mmButton.showButton();
            } else {
                this.mmButton.hideButton();
            }
        }
    }

    private void activateMode() {
        if (this.modeSelected && !this.modeActive) {
            MainApplication.getMap().mapView.addMouseListener((MouseListener)this.mouseAdapter);
            MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
            this.modeActive = true;
            this.updateStatusLine();
        }
    }

    private void deactivateMode() {
        if (this.modeActive) {
            MainApplication.getMap().mapView.removeMouseListener((MouseListener)this.mouseAdapter);
            MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
            this.modeActive = false;
        }
    }

    public void enterMode() {
        super.enterMode();
        this.modeSelected = true;
        if (!(MainApplication.getLayerManager().getActiveLayer() instanceof GeoImageLayer)) {
            this.activateMode();
        }
    }

    public void exitMode() {
        super.exitMode();
        this.deactivateMode();
        this.modeSelected = false;
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() instanceof GeoImageLayer) {
            this.deactivateMode();
        } else {
            this.activateMode();
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (this.modeActive) {
            this.updateStatusLine();
        }
        this.updateButtonState();
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent lre) {
        if (lre.getRemovedLayer() instanceof GeoImageLayer) {
            this.ignoreOneGILayer = true;
        }
        if (this.modeActive) {
            this.updateStatusLine();
        }
        this.updateButtonState();
        this.ignoreOneGILayer = false;
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    private void initAdapters() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PhotoAdjustMapMode.this.worker.doMousePressed(evt, PhotoAdjustMapMode.this.getVisibleGeoImageLayers());
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PhotoAdjustMapMode.this.worker.doMouseReleased(evt);
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PhotoAdjustMapMode.this.worker.doMouseDragged(evt);
            }
        };
    }

    private boolean hasLayersToAdjust() {
        MainLayerManager layerManager = MainApplication.getLayerManager();
        if (layerManager == null) {
            return false;
        }
        int giLayerNum = layerManager.getLayersOfType(GeoImageLayer.class).size();
        if (this.ignoreOneGILayer) {
            --giLayerNum;
        }
        return giLayerNum > 0;
    }

    private List<GeoImageLayer> getVisibleGeoImageLayers() {
        ArrayList<GeoImageLayer> all = new ArrayList<GeoImageLayer>(MainApplication.getLayerManager().getLayersOfType(GeoImageLayer.class));
        Iterator it = all.iterator();
        while (it.hasNext()) {
            if (((GeoImageLayer)it.next()).isVisible()) continue;
            it.remove();
        }
        return all;
    }

    public void destroy() {
        super.destroy();
        MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
    }
}

