/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Archive.Common;

import org.j7zip.Common.IntVector;
import org.j7zip.Common.RecordVector;
import org.j7zip.SevenZip.Archive.Common.BindPair;
import org.j7zip.SevenZip.Archive.Common.CoderStreamsInfo;

public class BindInfo {
    public RecordVector<CoderStreamsInfo> Coders = new RecordVector();
    public RecordVector<BindPair> BindPairs = new RecordVector();
    public IntVector InStreams = new IntVector();
    public IntVector OutStreams = new IntVector();

    public void Clear() {
        this.Coders.clear();
        this.BindPairs.clear();
        this.InStreams.clear();
        this.OutStreams.clear();
    }

    public int FindBinderForInStream(int inStream) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (((BindPair)this.BindPairs.get((int)i)).InIndex != inStream) continue;
            return i;
        }
        return -1;
    }

    public int FindBinderForOutStream(int outStream) {
        for (int i = 0; i < this.BindPairs.size(); ++i) {
            if (((BindPair)this.BindPairs.get((int)i)).OutIndex != outStream) continue;
            return i;
        }
        return -1;
    }

    public int GetCoderInStreamIndex(int coderIndex) {
        int streamIndex = 0;
        for (int i = 0; i < coderIndex; ++i) {
            streamIndex += ((CoderStreamsInfo)this.Coders.get((int)i)).NumInStreams;
        }
        return streamIndex;
    }

    public int GetCoderOutStreamIndex(int coderIndex) {
        int streamIndex = 0;
        for (int i = 0; i < coderIndex; ++i) {
            streamIndex += ((CoderStreamsInfo)this.Coders.get((int)i)).NumOutStreams;
        }
        return streamIndex;
    }

    public void FindInStream(int streamIndex, int[] coderIndex, int[] coderStreamIndex) {
        coderIndex[0] = 0;
        while (coderIndex[0] < this.Coders.size()) {
            int curSize = ((CoderStreamsInfo)this.Coders.get((int)coderIndex[0])).NumInStreams;
            if (streamIndex < curSize) {
                coderStreamIndex[0] = streamIndex;
                return;
            }
            streamIndex -= curSize;
            coderIndex[0] = coderIndex[0] + 1;
        }
        throw new UnknownError("1");
    }

    public void FindOutStream(int streamIndex, int[] coderIndex, int[] coderStreamIndex) {
        coderIndex[0] = 0;
        while (coderIndex[0] < this.Coders.size()) {
            int curSize = ((CoderStreamsInfo)this.Coders.get((int)coderIndex[0])).NumOutStreams;
            if (streamIndex < curSize) {
                coderStreamIndex[0] = streamIndex;
                return;
            }
            streamIndex -= curSize;
            coderIndex[0] = coderIndex[0] + 1;
        }
        throw new UnknownError("1");
    }
}

