/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.HashMap;
import java.util.Locale;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class PostalCodeChecker {
    private static HashMap<String, String> postalCodePatternMap = new HashMap();

    private PostalCodeChecker() {
    }

    public static boolean hasValidPostalCode(OSMAddress address) {
        CheckParameterUtil.ensureParameterNotNull((Object)address, (String)"address");
        if (!address.hasPostalCode()) {
            return false;
        }
        String ctry = PostalCodeChecker.getCountry(address);
        String postalCode = address.getPostalCode();
        return PostalCodeChecker.hasValidPostalCode(ctry, postalCode);
    }

    public static boolean hasValidPostalCode(String postalCode) {
        return PostalCodeChecker.hasValidPostalCode(PostalCodeChecker.getCountry(), postalCode);
    }

    public static boolean hasValidPostalCode(String country, String postalCode) {
        if (postalCodePatternMap.containsKey(country)) {
            String pattern = postalCodePatternMap.get(country);
            return postalCode.matches(pattern);
        }
        return true;
    }

    public static boolean isValidationSupported(String country) {
        CheckParameterUtil.ensureParameterNotNull((Object)country, (String)"country");
        return postalCodePatternMap.containsKey(country.toUpperCase());
    }

    public static boolean isValidationSupported(OSMAddress address) {
        CheckParameterUtil.ensureParameterNotNull((Object)address, (String)"address");
        String ctry = PostalCodeChecker.getCountry(address);
        return postalCodePatternMap.containsKey(ctry);
    }

    public static String getCountry() {
        return PostalCodeChecker.getCountry(null);
    }

    private static String getCountry(OSMAddress address) {
        String ctry = Locale.getDefault().getCountry();
        if (address != null && address.hasCountry()) {
            ctry = address.getCountry().toUpperCase();
        }
        return ctry;
    }

    private static void fillMap() {
        postalCodePatternMap.put("AL", "[0-9]{5}");
        postalCodePatternMap.put("AM", "[0-9]{4}");
        postalCodePatternMap.put("AR", "[A-Z]{1}[0-9]{4}[A-Z]{3}");
        postalCodePatternMap.put("AT", "[0-9]{4}");
        postalCodePatternMap.put("AU", "[0-9]{4}");
        postalCodePatternMap.put("BR", "[0-9]{5}-[0-9]{3}");
        postalCodePatternMap.put("CA", "[A-Z][0-9][A-Z] [0-9][A-Z][0-9]");
        postalCodePatternMap.put("CH", "[0-9]{4}");
        postalCodePatternMap.put("CN", "[0-9]{6}");
        postalCodePatternMap.put("CZ", "[0-9]{3} [0-9]{2}");
        postalCodePatternMap.put("DE", "[0-9]{5}");
        postalCodePatternMap.put("DK", "[0-9]{4}");
        postalCodePatternMap.put("EE", "[0-9]{5}");
        postalCodePatternMap.put("ES", "[0-9]{5}");
        postalCodePatternMap.put("FI", "[0-9]{5}");
        postalCodePatternMap.put("FR", "[0-9]{5}");
        postalCodePatternMap.put("GB", "[A-Z]{1,2}[0-9]{1,2}[A-Z]? [0-9]{1}[A-Z]{2}");
        postalCodePatternMap.put("GR", "[0-9]{5}");
        postalCodePatternMap.put("HR", "[0-9]{5}");
        postalCodePatternMap.put("HU", "[0-9]{4}");
        postalCodePatternMap.put("IL", "[0-9]{5}");
        postalCodePatternMap.put("IS", "[0-9]{3}");
        postalCodePatternMap.put("IT", "[0-9]{5}");
        postalCodePatternMap.put("JP", "[0-9]{3}-[0-9]{4}");
        postalCodePatternMap.put("LA", "[0-9]{5}");
        postalCodePatternMap.put("LI", "[0-9]{4}");
        postalCodePatternMap.put("LT", "[0-9]{5}");
        postalCodePatternMap.put("LU", "[0-9]{4}");
        postalCodePatternMap.put("LV", "[0-9]{4}");
        postalCodePatternMap.put("ME", "[0-9]{5}");
        postalCodePatternMap.put("MX", "[0-9]{5}");
        postalCodePatternMap.put("NL", "[0-9]{4} [A-Z]{2}");
        postalCodePatternMap.put("NO", "[0-9]{4}");
        postalCodePatternMap.put("PL", "[0-9]{2}-[0-9]{3}");
        postalCodePatternMap.put("PT", "[0-9]{4}-[0-9]{3}");
        postalCodePatternMap.put("RO", "[0-9]{6}");
        postalCodePatternMap.put("RU", "[0-9]{6}");
        postalCodePatternMap.put("SE", "[0-9]{3} [0-9]{2}");
        postalCodePatternMap.put("SI", "[0-9]{4}");
        postalCodePatternMap.put("SK", "[0-9]{3} [0-9]{2}");
        postalCodePatternMap.put("SL", "[0-9]{4}");
        postalCodePatternMap.put("SM", "[0-9]{5}");
        postalCodePatternMap.put("TR", "[0-9]{5}");
        postalCodePatternMap.put("UA", "[0-9]{5}");
        postalCodePatternMap.put("US", "([A-Z]{2} )?[0-9]{5}");
    }

    static {
        PostalCodeChecker.fillMap();
    }
}

