/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waypointSearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.plugins.waypointSearch.Engine;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

class SelectWaypointDialog
extends ToggleDialog
implements KeyListener,
MouseListener {
    private JTextField searchPattern = new JTextField(20);
    private DefaultListModel<String> listModel = new DefaultListModel();
    private JList<String> searchResult = new JList<String>(this.listModel);
    private transient List<Marker> searchResultObjectCache = new ArrayList<Marker>();
    private boolean firstTimeSearch = true;

    SelectWaypointDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        super(name, iconName, tooltip, shortcut, preferredHeight);
        this.build();
    }

    protected void build() {
        JPanel panel = new JPanel(new BorderLayout());
        this.searchPattern.setText(I18n.tr((String)"Enter search expression here..", (Object[])new Object[0]));
        this.searchPattern.addKeyListener(this);
        this.searchPattern.addMouseListener(this);
        panel.add((Component)this.searchPattern, "North");
        this.searchResult.setLayoutOrientation(0);
        this.searchResult.setSelectionMode(0);
        this.searchResult.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.searchResult);
        scrollPane.setHorizontalScrollBarPolicy(31);
        panel.add((Component)scrollPane, "Center");
        JLabel label = new JLabel(I18n.tr((String)"Select waypoint to move map", (Object[])new Object[0]));
        panel.add((Component)label, "South");
        this.createLayout(panel, false, null);
    }

    void updateSearchResults() {
        String searchfor = "";
        this.listModel.clear();
        this.searchResultObjectCache.clear();
        if (!this.firstTimeSearch) {
            searchfor = this.searchPattern.getText();
        }
        for (Marker marker : Engine.searchGpxWaypoints(searchfor)) {
            this.listModel.addElement(marker.getText());
            this.searchResultObjectCache.add(marker);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateSearchResults();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.firstTimeSearch = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx;
        if (e.getSource() == this.searchResult && (idx = this.searchResult.getSelectedIndex()) >= 0) {
            Marker marker = this.searchResultObjectCache.get(idx);
            MainApplication.getMap().mapView.zoomTo(marker.getCoor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.searchPattern.getSelectedText() == null) {
            this.searchPattern.selectAll();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

